// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class ModifyDocumentPermissionRequest private constructor(builder: Builder) {
    /**
     * The Amazon Web Services user accounts that should have access to the document. The account IDs can
     * either be a group of account IDs or All.
     */
    val accountIdsToAdd: List<String>? = builder.accountIdsToAdd
    /**
     * The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services
     * user account can either be a group of account IDs or All. This action has a
     * higher priority than AccountIdsToAdd. If you specify an account ID to add
     * and the same ID to remove, the system removes access to the document.
     */
    val accountIdsToRemove: List<String>? = builder.accountIdsToRemove
    /**
     * The name of the document that you want to share.
     */
    val name: kotlin.String? = builder.name
    /**
     * The permission type for the document. The permission type can be
     * Share.
     */
    val permissionType: aws.sdk.kotlin.services.ssm.model.DocumentPermissionType? = builder.permissionType
    /**
     * (Optional) The version of the document to share. If it isn't specified, the system choose
     * the Default version to share.
     */
    val sharedDocumentVersion: kotlin.String? = builder.sharedDocumentVersion

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ModifyDocumentPermissionRequest(")
        append("accountIdsToAdd=$accountIdsToAdd,")
        append("accountIdsToRemove=$accountIdsToRemove,")
        append("name=$name,")
        append("permissionType=$permissionType,")
        append("sharedDocumentVersion=$sharedDocumentVersion)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountIdsToAdd?.hashCode() ?: 0
        result = 31 * result + (accountIdsToRemove?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissionType?.hashCode() ?: 0)
        result = 31 * result + (sharedDocumentVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ModifyDocumentPermissionRequest

        if (accountIdsToAdd != other.accountIdsToAdd) return false
        if (accountIdsToRemove != other.accountIdsToRemove) return false
        if (name != other.name) return false
        if (permissionType != other.permissionType) return false
        if (sharedDocumentVersion != other.sharedDocumentVersion) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services user accounts that should have access to the document. The account IDs can
         * either be a group of account IDs or All.
         */
        var accountIdsToAdd: List<String>? = null
        /**
         * The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services
         * user account can either be a group of account IDs or All. This action has a
         * higher priority than AccountIdsToAdd. If you specify an account ID to add
         * and the same ID to remove, the system removes access to the document.
         */
        var accountIdsToRemove: List<String>? = null
        /**
         * The name of the document that you want to share.
         */
        var name: kotlin.String? = null
        /**
         * The permission type for the document. The permission type can be
         * Share.
         */
        var permissionType: aws.sdk.kotlin.services.ssm.model.DocumentPermissionType? = null
        /**
         * (Optional) The version of the document to share. If it isn't specified, the system choose
         * the Default version to share.
         */
        var sharedDocumentVersion: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest) : this() {
            this.accountIdsToAdd = x.accountIdsToAdd
            this.accountIdsToRemove = x.accountIdsToRemove
            this.name = x.name
            this.permissionType = x.permissionType
            this.sharedDocumentVersion = x.sharedDocumentVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ModifyDocumentPermissionRequest = ModifyDocumentPermissionRequest(this)
    }
}
