// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and
 * remediate operational work items (OpsItems) impacting the performance and health of their Amazon Web Services
 * resources. OpsCenter is integrated with Amazon EventBridge and Amazon CloudWatch. This
 * means you can configure these services to automatically create an OpsItem in OpsCenter when a
 * CloudWatch alarm enters the ALARM state or when EventBridge processes an event from
 * any Amazon Web Services service that publishes events. Configuring Amazon CloudWatch alarms and EventBridge events to automatically create OpsItems allows you to quickly diagnose and remediate
 * issues with Amazon Web Services resources from a single console.
 * To help you diagnose issues, each OpsItem includes contextually relevant information such as
 * the name and ID of the Amazon Web Services resource that generated the OpsItem, alarm or event details, alarm
 * history, and an alarm timeline graph. For the Amazon Web Services resource, OpsCenter aggregates information
 * from Config, CloudTrail logs, and EventBridge, so you don't have
 * to navigate across multiple console pages during your investigation. For more information, see
 * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter in the Amazon Web Services Systems Manager User Guide.
 */
class OpsItem private constructor(builder: Builder) {
    /**
     * The time a runbook workflow ended. Currently reported only for the OpsItem type
     * /aws/changerequest.
     */
    val actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualEndTime
    /**
     * The time a runbook workflow started. Currently reported only for the OpsItem type
     * /aws/changerequest.
     */
    val actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualStartTime
    /**
     * An OpsItem category. Category options include: Availability, Cost, Performance, Recovery,
     * Security.
     */
    val category: kotlin.String? = builder.category
    /**
     * The ARN of the Amazon Web Services account that created the OpsItem.
     */
    val createdBy: kotlin.String? = builder.createdBy
    /**
     * The date and time the OpsItem was created.
     */
    val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The OpsItem description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The ARN of the Amazon Web Services account that last updated the OpsItem.
     */
    val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * The date and time the OpsItem was last updated.
     */
    val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where
     * notifications are sent when this OpsItem is edited or changed.
     */
    val notifications: List<OpsItemNotification>? = builder.notifications
    /**
     * Operational data is custom data that provides useful reference details about the OpsItem.
     * For example, you can specify log files, error strings, license keys, troubleshooting tips, or
     * other relevant data. You enter operational data as key-value pairs. The key has a maximum length
     * of 128 characters. The value has a maximum size of 20 KB.
     *
     * Operational data keys can't begin with the following:
     * amazon, aws, amzn, ssm,
     * /amazon, /aws, /amzn, /ssm.
     *
     * You can choose to make the data searchable by other users in the account or you can restrict
     * search access. Searchable data means that all users with access to the OpsItem Overview page (as
     * provided by the DescribeOpsItems API operation) can view and search on the
     * specified data. Operational data that isn't searchable is only viewable by users who have access
     * to the OpsItem (as provided by the GetOpsItem API operation).
     * Use the /aws/resources key in OperationalData to specify a related resource in
     * the request. Use the /aws/automations key in OperationalData to associate an
     * Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually in the Amazon Web Services Systems Manager User Guide.
     */
    val operationalData: Map<String, OpsItemDataValue>? = builder.operationalData
    /**
     * The ID of the OpsItem.
     */
    val opsItemId: kotlin.String? = builder.opsItemId
    /**
     * The type of OpsItem. Currently, the only valid values are /aws/changerequest
     * and /aws/issue.
     */
    val opsItemType: kotlin.String? = builder.opsItemType
    /**
     * The time specified in a change request for a runbook workflow to end. Currently supported
     * only for the OpsItem type /aws/changerequest.
     */
    val plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedEndTime
    /**
     * The time specified in a change request for a runbook workflow to start. Currently supported
     * only for the OpsItem type /aws/changerequest.
     */
    val plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedStartTime
    /**
     * The importance of this OpsItem in relation to other OpsItems in the system.
     */
    val priority: kotlin.Int? = builder.priority
    /**
     * One or more OpsItems that share something in common with the current OpsItem. For example,
     * related OpsItems can include OpsItems with similar error messages, impacted resources, or
     * statuses for the impacted resource.
     */
    val relatedOpsItems: List<RelatedOpsItem>? = builder.relatedOpsItems
    /**
     * The severity of the OpsItem. Severity options range from 1 to 4.
     */
    val severity: kotlin.String? = builder.severity
    /**
     * The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of
     * source.
     */
    val source: kotlin.String? = builder.source
    /**
     * The OpsItem status. Status can be Open, In Progress, or
     * Resolved. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html">Editing OpsItem details in the Amazon Web Services Systems Manager User Guide.
     */
    val status: aws.sdk.kotlin.services.ssm.model.OpsItemStatus? = builder.status
    /**
     * A short heading that describes the nature of the OpsItem and the impacted resource.
     */
    val title: kotlin.String? = builder.title
    /**
     * The version of this OpsItem. Each time the OpsItem is edited the version number increments
     * by one.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.OpsItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpsItem(")
        append("actualEndTime=$actualEndTime,")
        append("actualStartTime=$actualStartTime,")
        append("category=$category,")
        append("createdBy=$createdBy,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("notifications=$notifications,")
        append("operationalData=$operationalData,")
        append("opsItemId=$opsItemId,")
        append("opsItemType=$opsItemType,")
        append("plannedEndTime=$plannedEndTime,")
        append("plannedStartTime=$plannedStartTime,")
        append("priority=$priority,")
        append("relatedOpsItems=$relatedOpsItems,")
        append("severity=$severity,")
        append("source=$source,")
        append("status=$status,")
        append("title=$title,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualEndTime?.hashCode() ?: 0
        result = 31 * result + (actualStartTime?.hashCode() ?: 0)
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (notifications?.hashCode() ?: 0)
        result = 31 * result + (operationalData?.hashCode() ?: 0)
        result = 31 * result + (opsItemId?.hashCode() ?: 0)
        result = 31 * result + (opsItemType?.hashCode() ?: 0)
        result = 31 * result + (plannedEndTime?.hashCode() ?: 0)
        result = 31 * result + (plannedStartTime?.hashCode() ?: 0)
        result = 31 * result + (priority ?: 0)
        result = 31 * result + (relatedOpsItems?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (source?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpsItem

        if (actualEndTime != other.actualEndTime) return false
        if (actualStartTime != other.actualStartTime) return false
        if (category != other.category) return false
        if (createdBy != other.createdBy) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (notifications != other.notifications) return false
        if (operationalData != other.operationalData) return false
        if (opsItemId != other.opsItemId) return false
        if (opsItemType != other.opsItemType) return false
        if (plannedEndTime != other.plannedEndTime) return false
        if (plannedStartTime != other.plannedStartTime) return false
        if (priority != other.priority) return false
        if (relatedOpsItems != other.relatedOpsItems) return false
        if (severity != other.severity) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (title != other.title) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.OpsItem = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time a runbook workflow ended. Currently reported only for the OpsItem type
         * /aws/changerequest.
         */
        var actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time a runbook workflow started. Currently reported only for the OpsItem type
         * /aws/changerequest.
         */
        var actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An OpsItem category. Category options include: Availability, Cost, Performance, Recovery,
         * Security.
         */
        var category: kotlin.String? = null
        /**
         * The ARN of the Amazon Web Services account that created the OpsItem.
         */
        var createdBy: kotlin.String? = null
        /**
         * The date and time the OpsItem was created.
         */
        var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The OpsItem description.
         */
        var description: kotlin.String? = null
        /**
         * The ARN of the Amazon Web Services account that last updated the OpsItem.
         */
        var lastModifiedBy: kotlin.String? = null
        /**
         * The date and time the OpsItem was last updated.
         */
        var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where
         * notifications are sent when this OpsItem is edited or changed.
         */
        var notifications: List<OpsItemNotification>? = null
        /**
         * Operational data is custom data that provides useful reference details about the OpsItem.
         * For example, you can specify log files, error strings, license keys, troubleshooting tips, or
         * other relevant data. You enter operational data as key-value pairs. The key has a maximum length
         * of 128 characters. The value has a maximum size of 20 KB.
         *
         * Operational data keys can't begin with the following:
         * amazon, aws, amzn, ssm,
         * /amazon, /aws, /amzn, /ssm.
         *
         * You can choose to make the data searchable by other users in the account or you can restrict
         * search access. Searchable data means that all users with access to the OpsItem Overview page (as
         * provided by the DescribeOpsItems API operation) can view and search on the
         * specified data. Operational data that isn't searchable is only viewable by users who have access
         * to the OpsItem (as provided by the GetOpsItem API operation).
         * Use the /aws/resources key in OperationalData to specify a related resource in
         * the request. Use the /aws/automations key in OperationalData to associate an
         * Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems">Creating OpsItems manually in the Amazon Web Services Systems Manager User Guide.
         */
        var operationalData: Map<String, OpsItemDataValue>? = null
        /**
         * The ID of the OpsItem.
         */
        var opsItemId: kotlin.String? = null
        /**
         * The type of OpsItem. Currently, the only valid values are /aws/changerequest
         * and /aws/issue.
         */
        var opsItemType: kotlin.String? = null
        /**
         * The time specified in a change request for a runbook workflow to end. Currently supported
         * only for the OpsItem type /aws/changerequest.
         */
        var plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time specified in a change request for a runbook workflow to start. Currently supported
         * only for the OpsItem type /aws/changerequest.
         */
        var plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The importance of this OpsItem in relation to other OpsItems in the system.
         */
        var priority: kotlin.Int? = null
        /**
         * One or more OpsItems that share something in common with the current OpsItem. For example,
         * related OpsItems can include OpsItems with similar error messages, impacted resources, or
         * statuses for the impacted resource.
         */
        var relatedOpsItems: List<RelatedOpsItem>? = null
        /**
         * The severity of the OpsItem. Severity options range from 1 to 4.
         */
        var severity: kotlin.String? = null
        /**
         * The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of
         * source.
         */
        var source: kotlin.String? = null
        /**
         * The OpsItem status. Status can be Open, In Progress, or
         * Resolved. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html">Editing OpsItem details in the Amazon Web Services Systems Manager User Guide.
         */
        var status: aws.sdk.kotlin.services.ssm.model.OpsItemStatus? = null
        /**
         * A short heading that describes the nature of the OpsItem and the impacted resource.
         */
        var title: kotlin.String? = null
        /**
         * The version of this OpsItem. Each time the OpsItem is edited the version number increments
         * by one.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.OpsItem) : this() {
            this.actualEndTime = x.actualEndTime
            this.actualStartTime = x.actualStartTime
            this.category = x.category
            this.createdBy = x.createdBy
            this.createdTime = x.createdTime
            this.description = x.description
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.notifications = x.notifications
            this.operationalData = x.operationalData
            this.opsItemId = x.opsItemId
            this.opsItemType = x.opsItemType
            this.plannedEndTime = x.plannedEndTime
            this.plannedStartTime = x.plannedStartTime
            this.priority = x.priority
            this.relatedOpsItems = x.relatedOpsItems
            this.severity = x.severity
            this.source = x.source
            this.status = x.status
            this.title = x.title
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.OpsItem = OpsItem(this)
    }
}
