// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An Amazon Web Services Systems Manager parameter in Parameter Store.
 */
class Parameter private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the parameter.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The data type of the parameter, such as text or aws:ec2:image. The
     * default is text.
     */
    val dataType: kotlin.String? = builder.dataType
    /**
     * Date the parameter was last changed or updated and the parameter version was created.
     */
    val lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedDate
    /**
     * The name of the parameter.
     */
    val name: kotlin.String? = builder.name
    /**
     * Either the version number or the label used to retrieve the parameter value. Specify
     * selectors by using one of the following formats:
     * parameter_name:version
     * parameter_name:label
     */
    val selector: kotlin.String? = builder.selector
    /**
     * Applies to parameters that reference information in other Amazon Web Services services.
     * SourceResult is the raw result or response from the source.
     */
    val sourceResult: kotlin.String? = builder.sourceResult
    /**
     * The type of parameter. Valid values include the following: String,
     * StringList, and SecureString.
     *
     * If type is StringList, the system returns a comma-separated string with no
     * spaces between commas in the Value field.
     */
    val type: aws.sdk.kotlin.services.ssm.model.ParameterType? = builder.type
    /**
     * The parameter value.
     *
     * If type is StringList, the system returns a comma-separated string with no
     * spaces between commas in the Value field.
     */
    val value: kotlin.String? = builder.value
    /**
     * The parameter version.
     */
    val version: kotlin.Long = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Parameter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Parameter(")
        append("arn=$arn,")
        append("dataType=$dataType,")
        append("lastModifiedDate=$lastModifiedDate,")
        append("name=$name,")
        append("selector=$selector,")
        append("sourceResult=$sourceResult,")
        append("type=$type,")
        append("value=*** Sensitive Data Redacted ***,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (selector?.hashCode() ?: 0)
        result = 31 * result + (sourceResult?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Parameter

        if (arn != other.arn) return false
        if (dataType != other.dataType) return false
        if (lastModifiedDate != other.lastModifiedDate) return false
        if (name != other.name) return false
        if (selector != other.selector) return false
        if (sourceResult != other.sourceResult) return false
        if (type != other.type) return false
        if (value != other.value) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Parameter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the parameter.
         */
        var arn: kotlin.String? = null
        /**
         * The data type of the parameter, such as text or aws:ec2:image. The
         * default is text.
         */
        var dataType: kotlin.String? = null
        /**
         * Date the parameter was last changed or updated and the parameter version was created.
         */
        var lastModifiedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the parameter.
         */
        var name: kotlin.String? = null
        /**
         * Either the version number or the label used to retrieve the parameter value. Specify
         * selectors by using one of the following formats:
         * parameter_name:version
         * parameter_name:label
         */
        var selector: kotlin.String? = null
        /**
         * Applies to parameters that reference information in other Amazon Web Services services.
         * SourceResult is the raw result or response from the source.
         */
        var sourceResult: kotlin.String? = null
        /**
         * The type of parameter. Valid values include the following: String,
         * StringList, and SecureString.
         *
         * If type is StringList, the system returns a comma-separated string with no
         * spaces between commas in the Value field.
         */
        var type: aws.sdk.kotlin.services.ssm.model.ParameterType? = null
        /**
         * The parameter value.
         *
         * If type is StringList, the system returns a comma-separated string with no
         * spaces between commas in the Value field.
         */
        var value: kotlin.String? = null
        /**
         * The parameter version.
         */
        var version: kotlin.Long = 0L

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Parameter) : this() {
            this.arn = x.arn
            this.dataType = x.dataType
            this.lastModifiedDate = x.lastModifiedDate
            this.name = x.name
            this.selector = x.selector
            this.sourceResult = x.sourceResult
            this.type = x.type
            this.value = x.value
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Parameter = Parameter(this)
    }
}
