// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * One or more filters. Use a filter to return a more specific list of results.
 */
class ParameterStringFilter private constructor(builder: Builder) {
    /**
     * The name of the filter.
     * The ParameterStringFilter object is used by the DescribeParameters and GetParametersByPath API operations.
     * However, not all of the pattern values listed for Key can be used with both
     * operations.
     * For DescribeParameters, all of the listed patterns are valid except
     * Label.
     * For GetParametersByPath, the following patterns listed for Key
     * aren't valid: tag, DataType, Name, Path, and
     * Tier.
     * For examples of Amazon Web Services CLI commands demonstrating valid parameter filter constructions, see
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html">Searching for Systems Manager parameters in the Amazon Web Services Systems Manager User Guide.
     */
    val key: kotlin.String? = builder.key
    /**
     * For all filters used with DescribeParameters, valid options include
     * Equals and BeginsWith. The Name filter additionally
     * supports the Contains option. (Exception: For filters using the key
     * Path, valid options include Recursive and
     * OneLevel.)
     * For filters used with GetParametersByPath, valid options include
     * Equals and BeginsWith. (Exception: For filters using
     * Label as the Key name, the only valid option is Equals.)
     */
    val option: kotlin.String? = builder.option
    /**
     * The value you want to search for.
     */
    val values: List<String>? = builder.values

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ParameterStringFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ParameterStringFilter(")
        append("key=$key,")
        append("option=$option,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (option?.hashCode() ?: 0)
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ParameterStringFilter

        if (key != other.key) return false
        if (option != other.option) return false
        if (values != other.values) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ParameterStringFilter = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the filter.
         * The ParameterStringFilter object is used by the DescribeParameters and GetParametersByPath API operations.
         * However, not all of the pattern values listed for Key can be used with both
         * operations.
         * For DescribeParameters, all of the listed patterns are valid except
         * Label.
         * For GetParametersByPath, the following patterns listed for Key
         * aren't valid: tag, DataType, Name, Path, and
         * Tier.
         * For examples of Amazon Web Services CLI commands demonstrating valid parameter filter constructions, see
         * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-search.html">Searching for Systems Manager parameters in the Amazon Web Services Systems Manager User Guide.
         */
        var key: kotlin.String? = null
        /**
         * For all filters used with DescribeParameters, valid options include
         * Equals and BeginsWith. The Name filter additionally
         * supports the Contains option. (Exception: For filters using the key
         * Path, valid options include Recursive and
         * OneLevel.)
         * For filters used with GetParametersByPath, valid options include
         * Equals and BeginsWith. (Exception: For filters using
         * Label as the Key name, the only valid option is Equals.)
         */
        var option: kotlin.String? = null
        /**
         * The value you want to search for.
         */
        var values: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ParameterStringFilter) : this() {
            this.key = x.key
            this.option = x.option
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ParameterStringFilter = ParameterStringFilter(this)
    }
}
