// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents metadata about a patch.
 */
class Patch private constructor(builder: Builder) {
    /**
     * The Advisory ID of the patch. For example, RHSA-2020:3779. Applies to
     * Linux-based managed nodes only.
     */
    val advisoryIds: List<String>? = builder.advisoryIds
    /**
     * The architecture of the patch. For example, in
     * example-pkg-0.710.10-2.7.abcd.x86_64, the architecture is indicated by
     * x86_64. Applies to Linux-based managed nodes only.
     */
    val arch: kotlin.String? = builder.arch
    /**
     * The Bugzilla ID of the patch. For example, 1600646. Applies to Linux-based
     * managed nodes only.
     */
    val bugzillaIds: List<String>? = builder.bugzillaIds
    /**
     * The classification of the patch. For example, SecurityUpdates,
     * Updates, or CriticalUpdates.
     */
    val classification: kotlin.String? = builder.classification
    /**
     * The URL where more information can be obtained about the patch.
     */
    val contentUrl: kotlin.String? = builder.contentUrl
    /**
     * The Common Vulnerabilities and Exposures (CVE) ID of the patch. For example,
     * CVE-2011-3192. Applies to Linux-based managed nodes only.
     */
    val cveIds: List<String>? = builder.cveIds
    /**
     * The description of the patch.
     */
    val description: kotlin.String? = builder.description
    /**
     * The epoch of the patch. For example in
     * pkg-example-EE-20180914-2.2.amzn1.noarch, the epoch value is
     * 20180914-2. Applies to Linux-based managed nodes only.
     */
    val epoch: kotlin.Int = builder.epoch
    /**
     * The ID of the patch. Applies to Windows patches only.
     *
     * This ID isn't the same as the Microsoft Knowledge Base ID.
     */
    val id: kotlin.String? = builder.id
    /**
     * The Microsoft Knowledge Base ID of the patch. Applies to Windows patches only.
     */
    val kbNumber: kotlin.String? = builder.kbNumber
    /**
     * The language of the patch if it's language-specific.
     */
    val language: kotlin.String? = builder.language
    /**
     * The ID of the Microsoft Security Response Center (MSRC) bulletin the patch is related to.
     * For example, MS14-045. Applies to Windows patches only.
     */
    val msrcNumber: kotlin.String? = builder.msrcNumber
    /**
     * The severity of the patch, such as Critical, Important, or
     * Moderate. Applies to Windows patches only.
     */
    val msrcSeverity: kotlin.String? = builder.msrcSeverity
    /**
     * The name of the patch. Applies to Linux-based managed nodes only.
     */
    val name: kotlin.String? = builder.name
    /**
     * The specific product the patch is applicable for. For example,
     * WindowsServer2016 or AmazonLinux2018.03.
     */
    val product: kotlin.String? = builder.product
    /**
     * The product family the patch is applicable for. For example, Windows or
     * Amazon Linux 2.
     */
    val productFamily: kotlin.String? = builder.productFamily
    /**
     * The particular release of a patch. For example, in
     * pkg-example-EE-20180914-2.2.amzn1.noarch, the release is 2.amaz1.
     * Applies to Linux-based managed nodes only.
     */
    val release: kotlin.String? = builder.release
    /**
     * The date the patch was released.
     */
    val releaseDate: aws.smithy.kotlin.runtime.time.Instant? = builder.releaseDate
    /**
     * The source patch repository for the operating system and version, such as
     * trusty-security for Ubuntu Server 14.04 LTE and focal-security for
     * Ubuntu Server 20.04 LTE. Applies to Linux-based managed nodes only.
     */
    val repository: kotlin.String? = builder.repository
    /**
     * The severity level of the patch. For example, CRITICAL or
     * MODERATE.
     */
    val severity: kotlin.String? = builder.severity
    /**
     * The title of the patch.
     */
    val title: kotlin.String? = builder.title
    /**
     * The name of the vendor providing the patch.
     */
    val vendor: kotlin.String? = builder.vendor
    /**
     * The version number of the patch. For example, in
     * example-pkg-1.710.10-2.7.abcd.x86_64, the version number is indicated by
     * -1. Applies to Linux-based managed nodes only.
     */
    val version: kotlin.String? = builder.version

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Patch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Patch(")
        append("advisoryIds=$advisoryIds,")
        append("arch=$arch,")
        append("bugzillaIds=$bugzillaIds,")
        append("classification=$classification,")
        append("contentUrl=$contentUrl,")
        append("cveIds=$cveIds,")
        append("description=$description,")
        append("epoch=$epoch,")
        append("id=$id,")
        append("kbNumber=$kbNumber,")
        append("language=$language,")
        append("msrcNumber=$msrcNumber,")
        append("msrcSeverity=$msrcSeverity,")
        append("name=$name,")
        append("product=$product,")
        append("productFamily=$productFamily,")
        append("release=$release,")
        append("releaseDate=$releaseDate,")
        append("repository=$repository,")
        append("severity=$severity,")
        append("title=$title,")
        append("vendor=$vendor,")
        append("version=$version)")
    }

    override fun hashCode(): kotlin.Int {
        var result = advisoryIds?.hashCode() ?: 0
        result = 31 * result + (arch?.hashCode() ?: 0)
        result = 31 * result + (bugzillaIds?.hashCode() ?: 0)
        result = 31 * result + (classification?.hashCode() ?: 0)
        result = 31 * result + (contentUrl?.hashCode() ?: 0)
        result = 31 * result + (cveIds?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (epoch)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (kbNumber?.hashCode() ?: 0)
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (msrcNumber?.hashCode() ?: 0)
        result = 31 * result + (msrcSeverity?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (product?.hashCode() ?: 0)
        result = 31 * result + (productFamily?.hashCode() ?: 0)
        result = 31 * result + (release?.hashCode() ?: 0)
        result = 31 * result + (releaseDate?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (vendor?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Patch

        if (advisoryIds != other.advisoryIds) return false
        if (arch != other.arch) return false
        if (bugzillaIds != other.bugzillaIds) return false
        if (classification != other.classification) return false
        if (contentUrl != other.contentUrl) return false
        if (cveIds != other.cveIds) return false
        if (description != other.description) return false
        if (epoch != other.epoch) return false
        if (id != other.id) return false
        if (kbNumber != other.kbNumber) return false
        if (language != other.language) return false
        if (msrcNumber != other.msrcNumber) return false
        if (msrcSeverity != other.msrcSeverity) return false
        if (name != other.name) return false
        if (product != other.product) return false
        if (productFamily != other.productFamily) return false
        if (release != other.release) return false
        if (releaseDate != other.releaseDate) return false
        if (repository != other.repository) return false
        if (severity != other.severity) return false
        if (title != other.title) return false
        if (vendor != other.vendor) return false
        if (version != other.version) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Patch = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Advisory ID of the patch. For example, RHSA-2020:3779. Applies to
         * Linux-based managed nodes only.
         */
        var advisoryIds: List<String>? = null
        /**
         * The architecture of the patch. For example, in
         * example-pkg-0.710.10-2.7.abcd.x86_64, the architecture is indicated by
         * x86_64. Applies to Linux-based managed nodes only.
         */
        var arch: kotlin.String? = null
        /**
         * The Bugzilla ID of the patch. For example, 1600646. Applies to Linux-based
         * managed nodes only.
         */
        var bugzillaIds: List<String>? = null
        /**
         * The classification of the patch. For example, SecurityUpdates,
         * Updates, or CriticalUpdates.
         */
        var classification: kotlin.String? = null
        /**
         * The URL where more information can be obtained about the patch.
         */
        var contentUrl: kotlin.String? = null
        /**
         * The Common Vulnerabilities and Exposures (CVE) ID of the patch. For example,
         * CVE-2011-3192. Applies to Linux-based managed nodes only.
         */
        var cveIds: List<String>? = null
        /**
         * The description of the patch.
         */
        var description: kotlin.String? = null
        /**
         * The epoch of the patch. For example in
         * pkg-example-EE-20180914-2.2.amzn1.noarch, the epoch value is
         * 20180914-2. Applies to Linux-based managed nodes only.
         */
        var epoch: kotlin.Int = 0
        /**
         * The ID of the patch. Applies to Windows patches only.
         *
         * This ID isn't the same as the Microsoft Knowledge Base ID.
         */
        var id: kotlin.String? = null
        /**
         * The Microsoft Knowledge Base ID of the patch. Applies to Windows patches only.
         */
        var kbNumber: kotlin.String? = null
        /**
         * The language of the patch if it's language-specific.
         */
        var language: kotlin.String? = null
        /**
         * The ID of the Microsoft Security Response Center (MSRC) bulletin the patch is related to.
         * For example, MS14-045. Applies to Windows patches only.
         */
        var msrcNumber: kotlin.String? = null
        /**
         * The severity of the patch, such as Critical, Important, or
         * Moderate. Applies to Windows patches only.
         */
        var msrcSeverity: kotlin.String? = null
        /**
         * The name of the patch. Applies to Linux-based managed nodes only.
         */
        var name: kotlin.String? = null
        /**
         * The specific product the patch is applicable for. For example,
         * WindowsServer2016 or AmazonLinux2018.03.
         */
        var product: kotlin.String? = null
        /**
         * The product family the patch is applicable for. For example, Windows or
         * Amazon Linux 2.
         */
        var productFamily: kotlin.String? = null
        /**
         * The particular release of a patch. For example, in
         * pkg-example-EE-20180914-2.2.amzn1.noarch, the release is 2.amaz1.
         * Applies to Linux-based managed nodes only.
         */
        var release: kotlin.String? = null
        /**
         * The date the patch was released.
         */
        var releaseDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The source patch repository for the operating system and version, such as
         * trusty-security for Ubuntu Server 14.04 LTE and focal-security for
         * Ubuntu Server 20.04 LTE. Applies to Linux-based managed nodes only.
         */
        var repository: kotlin.String? = null
        /**
         * The severity level of the patch. For example, CRITICAL or
         * MODERATE.
         */
        var severity: kotlin.String? = null
        /**
         * The title of the patch.
         */
        var title: kotlin.String? = null
        /**
         * The name of the vendor providing the patch.
         */
        var vendor: kotlin.String? = null
        /**
         * The version number of the patch. For example, in
         * example-pkg-1.710.10-2.7.abcd.x86_64, the version number is indicated by
         * -1. Applies to Linux-based managed nodes only.
         */
        var version: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Patch) : this() {
            this.advisoryIds = x.advisoryIds
            this.arch = x.arch
            this.bugzillaIds = x.bugzillaIds
            this.classification = x.classification
            this.contentUrl = x.contentUrl
            this.cveIds = x.cveIds
            this.description = x.description
            this.epoch = x.epoch
            this.id = x.id
            this.kbNumber = x.kbNumber
            this.language = x.language
            this.msrcNumber = x.msrcNumber
            this.msrcSeverity = x.msrcSeverity
            this.name = x.name
            this.product = x.product
            this.productFamily = x.productFamily
            this.release = x.release
            this.releaseDate = x.releaseDate
            this.repository = x.repository
            this.severity = x.severity
            this.title = x.title
            this.vendor = x.vendor
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Patch = Patch(this)
    }
}
