// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about the state of a patch on a particular managed node as it relates to the
 * patch baseline used to patch the node.
 */
class PatchComplianceData private constructor(builder: Builder) {
    /**
     * The classification of the patch, such as SecurityUpdates, Updates,
     * and CriticalUpdates.
     */
    val classification: kotlin.String? = builder.classification
    /**
     * The IDs of one or more Common Vulnerabilities and Exposure (CVE) issues that are resolved by
     * the patch.
     */
    val cveIds: kotlin.String? = builder.cveIds
    /**
     * The date/time the patch was installed on the managed node. Not all operating systems provide
     * this level of information.
     */
    val installedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.installedTime
    /**
     * The operating system-specific ID of the patch.
     */
    val kbId: kotlin.String? = builder.kbId
    /**
     * The severity of the patch such as Critical, Important, and
     * Moderate.
     */
    val severity: kotlin.String? = builder.severity
    /**
     * The state of the patch on the managed node, such as INSTALLED or FAILED.
     * For descriptions of each patch state, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-compliance-about.html#sysman-compliance-monitor-patch">About patch compliance in the Amazon Web Services Systems Manager User Guide.
     */
    val state: aws.sdk.kotlin.services.ssm.model.PatchComplianceDataState? = builder.state
    /**
     * The title of the patch.
     */
    val title: kotlin.String? = builder.title

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PatchComplianceData = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchComplianceData(")
        append("classification=$classification,")
        append("cveIds=$cveIds,")
        append("installedTime=$installedTime,")
        append("kbId=$kbId,")
        append("severity=$severity,")
        append("state=$state,")
        append("title=$title)")
    }

    override fun hashCode(): kotlin.Int {
        var result = classification?.hashCode() ?: 0
        result = 31 * result + (cveIds?.hashCode() ?: 0)
        result = 31 * result + (installedTime?.hashCode() ?: 0)
        result = 31 * result + (kbId?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchComplianceData

        if (classification != other.classification) return false
        if (cveIds != other.cveIds) return false
        if (installedTime != other.installedTime) return false
        if (kbId != other.kbId) return false
        if (severity != other.severity) return false
        if (state != other.state) return false
        if (title != other.title) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PatchComplianceData = Builder(this).apply(block).build()

    class Builder {
        /**
         * The classification of the patch, such as SecurityUpdates, Updates,
         * and CriticalUpdates.
         */
        var classification: kotlin.String? = null
        /**
         * The IDs of one or more Common Vulnerabilities and Exposure (CVE) issues that are resolved by
         * the patch.
         */
        var cveIds: kotlin.String? = null
        /**
         * The date/time the patch was installed on the managed node. Not all operating systems provide
         * this level of information.
         */
        var installedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The operating system-specific ID of the patch.
         */
        var kbId: kotlin.String? = null
        /**
         * The severity of the patch such as Critical, Important, and
         * Moderate.
         */
        var severity: kotlin.String? = null
        /**
         * The state of the patch on the managed node, such as INSTALLED or FAILED.
         * For descriptions of each patch state, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-compliance-about.html#sysman-compliance-monitor-patch">About patch compliance in the Amazon Web Services Systems Manager User Guide.
         */
        var state: aws.sdk.kotlin.services.ssm.model.PatchComplianceDataState? = null
        /**
         * The title of the patch.
         */
        var title: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PatchComplianceData) : this() {
            this.classification = x.classification
            this.cveIds = x.cveIds
            this.installedTime = x.installedTime
            this.kbId = x.kbId
            this.severity = x.severity
            this.state = x.state
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PatchComplianceData = PatchComplianceData(this)
    }
}
