// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a resource data sync configuration, including its current status and last
 * successful sync.
 */
class ResourceDataSyncItem private constructor(builder: Builder) {
    /**
     * The status reported by the last sync.
     */
    val lastStatus: aws.sdk.kotlin.services.ssm.model.LastResourceDataSyncStatus? = builder.lastStatus
    /**
     * The last time the sync operations returned a status of SUCCESSFUL (UTC).
     */
    val lastSuccessfulSyncTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSuccessfulSyncTime
    /**
     * The status message details reported by the last sync.
     */
    val lastSyncStatusMessage: kotlin.String? = builder.lastSyncStatusMessage
    /**
     * The last time the configuration attempted to sync (UTC).
     */
    val lastSyncTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSyncTime
    /**
     * Configuration information for the target S3 bucket.
     */
    val s3Destination: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination? = builder.s3Destination
    /**
     * The date and time the configuration was created (UTC).
     */
    val syncCreatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.syncCreatedTime
    /**
     * The date and time the resource data sync was changed.
     */
    val syncLastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.syncLastModifiedTime
    /**
     * The name of the resource data sync.
     */
    val syncName: kotlin.String? = builder.syncName
    /**
     * Information about the source where the data was synchronized.
     */
    val syncSource: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState? = builder.syncSource
    /**
     * The type of resource data sync. If SyncType is SyncToDestination,
     * then the resource data sync synchronizes data to an S3 bucket. If the SyncType is
     * SyncFromSource then the resource data sync synchronizes data from Organizations or from
     * multiple Amazon Web Services Regions.
     */
    val syncType: kotlin.String? = builder.syncType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDataSyncItem(")
        append("lastStatus=$lastStatus,")
        append("lastSuccessfulSyncTime=$lastSuccessfulSyncTime,")
        append("lastSyncStatusMessage=$lastSyncStatusMessage,")
        append("lastSyncTime=$lastSyncTime,")
        append("s3Destination=$s3Destination,")
        append("syncCreatedTime=$syncCreatedTime,")
        append("syncLastModifiedTime=$syncLastModifiedTime,")
        append("syncName=$syncName,")
        append("syncSource=$syncSource,")
        append("syncType=$syncType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = lastStatus?.hashCode() ?: 0
        result = 31 * result + (lastSuccessfulSyncTime?.hashCode() ?: 0)
        result = 31 * result + (lastSyncStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (lastSyncTime?.hashCode() ?: 0)
        result = 31 * result + (s3Destination?.hashCode() ?: 0)
        result = 31 * result + (syncCreatedTime?.hashCode() ?: 0)
        result = 31 * result + (syncLastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (syncName?.hashCode() ?: 0)
        result = 31 * result + (syncSource?.hashCode() ?: 0)
        result = 31 * result + (syncType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDataSyncItem

        if (lastStatus != other.lastStatus) return false
        if (lastSuccessfulSyncTime != other.lastSuccessfulSyncTime) return false
        if (lastSyncStatusMessage != other.lastSyncStatusMessage) return false
        if (lastSyncTime != other.lastSyncTime) return false
        if (s3Destination != other.s3Destination) return false
        if (syncCreatedTime != other.syncCreatedTime) return false
        if (syncLastModifiedTime != other.syncLastModifiedTime) return false
        if (syncName != other.syncName) return false
        if (syncSource != other.syncSource) return false
        if (syncType != other.syncType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncItem = Builder(this).apply(block).build()

    class Builder {
        /**
         * The status reported by the last sync.
         */
        var lastStatus: aws.sdk.kotlin.services.ssm.model.LastResourceDataSyncStatus? = null
        /**
         * The last time the sync operations returned a status of SUCCESSFUL (UTC).
         */
        var lastSuccessfulSyncTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status message details reported by the last sync.
         */
        var lastSyncStatusMessage: kotlin.String? = null
        /**
         * The last time the configuration attempted to sync (UTC).
         */
        var lastSyncTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Configuration information for the target S3 bucket.
         */
        var s3Destination: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination? = null
        /**
         * The date and time the configuration was created (UTC).
         */
        var syncCreatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time the resource data sync was changed.
         */
        var syncLastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the resource data sync.
         */
        var syncName: kotlin.String? = null
        /**
         * Information about the source where the data was synchronized.
         */
        var syncSource: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState? = null
        /**
         * The type of resource data sync. If SyncType is SyncToDestination,
         * then the resource data sync synchronizes data to an S3 bucket. If the SyncType is
         * SyncFromSource then the resource data sync synchronizes data from Organizations or from
         * multiple Amazon Web Services Regions.
         */
        var syncType: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncItem) : this() {
            this.lastStatus = x.lastStatus
            this.lastSuccessfulSyncTime = x.lastSuccessfulSyncTime
            this.lastSyncStatusMessage = x.lastSyncStatusMessage
            this.lastSyncTime = x.lastSyncTime
            this.s3Destination = x.s3Destination
            this.syncCreatedTime = x.syncCreatedTime
            this.syncLastModifiedTime = x.syncLastModifiedTime
            this.syncName = x.syncName
            this.syncSource = x.syncSource
            this.syncType = x.syncType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncItem = ResourceDataSyncItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination] inside the given [block]
         */
        fun s3Destination(block: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination.Builder.() -> kotlin.Unit) {
            this.s3Destination = aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState] inside the given [block]
         */
        fun syncSource(block: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState.Builder.() -> kotlin.Unit) {
            this.syncSource = aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState.invoke(block)
        }
    }
}
