// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information about the target S3 bucket for the resource data sync.
 */
class ResourceDataSyncS3Destination private constructor(builder: Builder) {
    /**
     * The ARN of an encryption key for a destination in Amazon S3. Must belong to the same
     * Region as the destination S3 bucket.
     */
    val awskmsKeyArn: kotlin.String? = builder.awskmsKeyArn
    /**
     * The name of the S3 bucket where the aggregated data is stored.
     */
    val bucketName: kotlin.String? = builder.bucketName
    /**
     * Enables destination data sharing. By default, this field is null.
     */
    val destinationDataSharing: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncDestinationDataSharing? = builder.destinationDataSharing
    /**
     * An Amazon S3 prefix for the bucket.
     */
    val prefix: kotlin.String? = builder.prefix
    /**
     * The Amazon Web Services Region with the S3 bucket targeted by the resource data sync.
     */
    val region: kotlin.String? = builder.region
    /**
     * A supported sync format. The following format is currently supported: JsonSerDe
     */
    val syncFormat: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Format? = builder.syncFormat

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDataSyncS3Destination(")
        append("awskmsKeyArn=$awskmsKeyArn,")
        append("bucketName=$bucketName,")
        append("destinationDataSharing=$destinationDataSharing,")
        append("prefix=$prefix,")
        append("region=$region,")
        append("syncFormat=$syncFormat)")
    }

    override fun hashCode(): kotlin.Int {
        var result = awskmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (destinationDataSharing?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (syncFormat?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDataSyncS3Destination

        if (awskmsKeyArn != other.awskmsKeyArn) return false
        if (bucketName != other.bucketName) return false
        if (destinationDataSharing != other.destinationDataSharing) return false
        if (prefix != other.prefix) return false
        if (region != other.region) return false
        if (syncFormat != other.syncFormat) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ARN of an encryption key for a destination in Amazon S3. Must belong to the same
         * Region as the destination S3 bucket.
         */
        var awskmsKeyArn: kotlin.String? = null
        /**
         * The name of the S3 bucket where the aggregated data is stored.
         */
        var bucketName: kotlin.String? = null
        /**
         * Enables destination data sharing. By default, this field is null.
         */
        var destinationDataSharing: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncDestinationDataSharing? = null
        /**
         * An Amazon S3 prefix for the bucket.
         */
        var prefix: kotlin.String? = null
        /**
         * The Amazon Web Services Region with the S3 bucket targeted by the resource data sync.
         */
        var region: kotlin.String? = null
        /**
         * A supported sync format. The following format is currently supported: JsonSerDe
         */
        var syncFormat: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Format? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination) : this() {
            this.awskmsKeyArn = x.awskmsKeyArn
            this.bucketName = x.bucketName
            this.destinationDataSharing = x.destinationDataSharing
            this.prefix = x.prefix
            this.region = x.region
            this.syncFormat = x.syncFormat
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncS3Destination = ResourceDataSyncS3Destination(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ResourceDataSyncDestinationDataSharing] inside the given [block]
         */
        fun destinationDataSharing(block: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncDestinationDataSharing.Builder.() -> kotlin.Unit) {
            this.destinationDataSharing = aws.sdk.kotlin.services.ssm.model.ResourceDataSyncDestinationDataSharing.invoke(block)
        }
    }
}
