// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class ResumeSessionResponse private constructor(builder: Builder) {
    /**
     * The ID of the session.
     */
    val sessionId: kotlin.String? = builder.sessionId
    /**
     * A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and
     * receive output from the managed node. Format: wss://ssmmessages.region.amazonaws.com/v1/data-channel/session-id?stream=(input|output).
     *
     * region represents the Region identifier for an
     * Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as us-east-2 for the US East (Ohio) Region.
     * For a list of supported region values, see the Region column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints in the
     * Amazon Web Services General Reference.
     *
     * session-id represents the ID of a Session Manager session, such as
     * 1a2b3c4dEXAMPLE.
     */
    val streamUrl: kotlin.String? = builder.streamUrl
    /**
     * An encrypted token value containing session and caller information. Used to authenticate the
     * connection to the managed node.
     */
    val tokenValue: kotlin.String? = builder.tokenValue

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ResumeSessionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResumeSessionResponse(")
        append("sessionId=$sessionId,")
        append("streamUrl=$streamUrl,")
        append("tokenValue=$tokenValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = sessionId?.hashCode() ?: 0
        result = 31 * result + (streamUrl?.hashCode() ?: 0)
        result = 31 * result + (tokenValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResumeSessionResponse

        if (sessionId != other.sessionId) return false
        if (streamUrl != other.streamUrl) return false
        if (tokenValue != other.tokenValue) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ResumeSessionResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The ID of the session.
         */
        var sessionId: kotlin.String? = null
        /**
         * A URL back to SSM Agent on the managed node that the Session Manager client uses to send commands and
         * receive output from the managed node. Format: wss://ssmmessages.region.amazonaws.com/v1/data-channel/session-id?stream=(input|output).
         *
         * region represents the Region identifier for an
         * Amazon Web Services Region supported by Amazon Web Services Systems Manager, such as us-east-2 for the US East (Ohio) Region.
         * For a list of supported region values, see the Region column in <a href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#ssm_region">Systems Manager service endpoints in the
         * Amazon Web Services General Reference.
         *
         * session-id represents the ID of a Session Manager session, such as
         * 1a2b3c4dEXAMPLE.
         */
        var streamUrl: kotlin.String? = null
        /**
         * An encrypted token value containing session and caller information. Used to authenticate the
         * connection to the managed node.
         */
        var tokenValue: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ResumeSessionResponse) : this() {
            this.sessionId = x.sessionId
            this.streamUrl = x.streamUrl
            this.tokenValue = x.tokenValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ResumeSessionResponse = ResumeSessionResponse(this)
    }
}
