// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * Information about an Automation runbook used in a runbook workflow in Change Manager.
 *
 * The Automation runbooks specified for the runbook workflow can't run until all required
 * approvals for the change request have been received.
 */
class Runbook private constructor(builder: Builder) {
    /**
     * The name of the Automation runbook used in a runbook workflow.
     */
    val documentName: kotlin.String? = builder.documentName
    /**
     * The version of the Automation runbook used in a runbook workflow.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The MaxConcurrency value specified by the user when the operation started,
     * indicating the maximum number of resources that the runbook operation can run on at the same
     * time.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The MaxErrors value specified by the user when the execution started,
     * indicating the maximum number of errors that can occur during the operation before the updates
     * are stopped or rolled back.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The key-value map of execution parameters, which were supplied when calling
     * StartChangeRequestExecution.
     */
    val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Runbook
     * operation.
     */
    val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * The name of the parameter used as the target resource for the rate-controlled
     * runbook workflow. Required if you specify Targets.
     */
    val targetParameterName: kotlin.String? = builder.targetParameterName
    /**
     * A key-value mapping to target resources that the runbook operation performs tasks on.
     * Required if you specify TargetParameterName.
     */
    val targets: List<Target>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Runbook = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Runbook(")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("parameters=$parameters,")
        append("targetLocations=$targetLocations,")
        append("targetParameterName=$targetParameterName,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentName?.hashCode() ?: 0
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targetParameterName?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Runbook

        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (parameters != other.parameters) return false
        if (targetLocations != other.targetLocations) return false
        if (targetParameterName != other.targetParameterName) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Runbook = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the Automation runbook used in a runbook workflow.
         */
        var documentName: kotlin.String? = null
        /**
         * The version of the Automation runbook used in a runbook workflow.
         */
        var documentVersion: kotlin.String? = null
        /**
         * The MaxConcurrency value specified by the user when the operation started,
         * indicating the maximum number of resources that the runbook operation can run on at the same
         * time.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The MaxErrors value specified by the user when the execution started,
         * indicating the maximum number of errors that can occur during the operation before the updates
         * are stopped or rolled back.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The key-value map of execution parameters, which were supplied when calling
         * StartChangeRequestExecution.
         */
        var parameters: Map<String, List<String>>? = null
        /**
         * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Runbook
         * operation.
         */
        var targetLocations: List<TargetLocation>? = null
        /**
         * The name of the parameter used as the target resource for the rate-controlled
         * runbook workflow. Required if you specify Targets.
         */
        var targetParameterName: kotlin.String? = null
        /**
         * A key-value mapping to target resources that the runbook operation performs tasks on.
         * Required if you specify TargetParameterName.
         */
        var targets: List<Target>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Runbook) : this() {
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.parameters = x.parameters
            this.targetLocations = x.targetLocations
            this.targetParameterName = x.targetParameterName
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Runbook = Runbook(this)
    }
}
