// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class SendAutomationSignalRequest private constructor(builder: Builder) {
    /**
     * The unique identifier for an existing Automation execution that you want to send the signal
     * to.
     */
    val automationExecutionId: kotlin.String? = builder.automationExecutionId
    /**
     * The data sent with the signal. The data schema depends on the type of signal used in the
     * request.
     * For Approve and Reject signal types, the payload is an optional
     * comment that you can send with the signal type. For example:
     *
     * Comment="Looks good"
     *
     * For StartStep and Resume signal types, you must send the name of
     * the Automation step to start or resume as the payload. For example:
     *
     * StepName="step1"
     *
     * For the StopStep signal type, you must send the step execution ID as the
     * payload. For example:
     *
     * StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"
     */
    val payload: Map<String, List<String>>? = builder.payload
    /**
     * The type of signal to send to an Automation execution.
     */
    val signalType: aws.sdk.kotlin.services.ssm.model.SignalType? = builder.signalType

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.SendAutomationSignalRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SendAutomationSignalRequest(")
        append("automationExecutionId=$automationExecutionId,")
        append("payload=$payload,")
        append("signalType=$signalType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = automationExecutionId?.hashCode() ?: 0
        result = 31 * result + (payload?.hashCode() ?: 0)
        result = 31 * result + (signalType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SendAutomationSignalRequest

        if (automationExecutionId != other.automationExecutionId) return false
        if (payload != other.payload) return false
        if (signalType != other.signalType) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.SendAutomationSignalRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier for an existing Automation execution that you want to send the signal
         * to.
         */
        var automationExecutionId: kotlin.String? = null
        /**
         * The data sent with the signal. The data schema depends on the type of signal used in the
         * request.
         * For Approve and Reject signal types, the payload is an optional
         * comment that you can send with the signal type. For example:
         *
         * Comment="Looks good"
         *
         * For StartStep and Resume signal types, you must send the name of
         * the Automation step to start or resume as the payload. For example:
         *
         * StepName="step1"
         *
         * For the StopStep signal type, you must send the step execution ID as the
         * payload. For example:
         *
         * StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"
         */
        var payload: Map<String, List<String>>? = null
        /**
         * The type of signal to send to an Automation execution.
         */
        var signalType: aws.sdk.kotlin.services.ssm.model.SignalType? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.SendAutomationSignalRequest) : this() {
            this.automationExecutionId = x.automationExecutionId
            this.payload = x.payload
            this.signalType = x.signalType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.SendAutomationSignalRequest = SendAutomationSignalRequest(this)
    }
}
