// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a Session Manager connection to a managed node.
 */
class Session private constructor(builder: Builder) {
    /**
     * Reserved for future use.
     */
    val details: kotlin.String? = builder.details
    /**
     * The name of the Session Manager SSM document used to define the parameters and plugin settings for the
     * session. For example, SSM-SessionManagerRunShell.
     */
    val documentName: kotlin.String? = builder.documentName
    /**
     * The date and time, in ISO-8601 Extended format, when the session was terminated.
     */
    val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * The maximum duration of a session before it terminates.
     */
    val maxSessionDuration: kotlin.String? = builder.maxSessionDuration
    /**
     * Reserved for future use.
     */
    val outputUrl: aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl? = builder.outputUrl
    /**
     * The ID of the Amazon Web Services user account that started the session.
     */
    val owner: kotlin.String? = builder.owner
    /**
     * The reason for connecting to the instance.
     */
    val reason: kotlin.String? = builder.reason
    /**
     * The ID of the session.
     */
    val sessionId: kotlin.String? = builder.sessionId
    /**
     * The date and time, in ISO-8601 Extended format, when the session began.
     */
    val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The status of the session. For example, "Connected" or "Terminated".
     */
    val status: aws.sdk.kotlin.services.ssm.model.SessionStatus? = builder.status
    /**
     * The managed node that the Session Manager session connected to.
     */
    val target: kotlin.String? = builder.target

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Session = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Session(")
        append("details=$details,")
        append("documentName=$documentName,")
        append("endDate=$endDate,")
        append("maxSessionDuration=$maxSessionDuration,")
        append("outputUrl=$outputUrl,")
        append("owner=$owner,")
        append("reason=$reason,")
        append("sessionId=$sessionId,")
        append("startDate=$startDate,")
        append("status=$status,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = details?.hashCode() ?: 0
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (maxSessionDuration?.hashCode() ?: 0)
        result = 31 * result + (outputUrl?.hashCode() ?: 0)
        result = 31 * result + (owner?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (sessionId?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Session

        if (details != other.details) return false
        if (documentName != other.documentName) return false
        if (endDate != other.endDate) return false
        if (maxSessionDuration != other.maxSessionDuration) return false
        if (outputUrl != other.outputUrl) return false
        if (owner != other.owner) return false
        if (reason != other.reason) return false
        if (sessionId != other.sessionId) return false
        if (startDate != other.startDate) return false
        if (status != other.status) return false
        if (target != other.target) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Session = Builder(this).apply(block).build()

    class Builder {
        /**
         * Reserved for future use.
         */
        var details: kotlin.String? = null
        /**
         * The name of the Session Manager SSM document used to define the parameters and plugin settings for the
         * session. For example, SSM-SessionManagerRunShell.
         */
        var documentName: kotlin.String? = null
        /**
         * The date and time, in ISO-8601 Extended format, when the session was terminated.
         */
        var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The maximum duration of a session before it terminates.
         */
        var maxSessionDuration: kotlin.String? = null
        /**
         * Reserved for future use.
         */
        var outputUrl: aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl? = null
        /**
         * The ID of the Amazon Web Services user account that started the session.
         */
        var owner: kotlin.String? = null
        /**
         * The reason for connecting to the instance.
         */
        var reason: kotlin.String? = null
        /**
         * The ID of the session.
         */
        var sessionId: kotlin.String? = null
        /**
         * The date and time, in ISO-8601 Extended format, when the session began.
         */
        var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the session. For example, "Connected" or "Terminated".
         */
        var status: aws.sdk.kotlin.services.ssm.model.SessionStatus? = null
        /**
         * The managed node that the Session Manager session connected to.
         */
        var target: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Session) : this() {
            this.details = x.details
            this.documentName = x.documentName
            this.endDate = x.endDate
            this.maxSessionDuration = x.maxSessionDuration
            this.outputUrl = x.outputUrl
            this.owner = x.owner
            this.reason = x.reason
            this.sessionId = x.sessionId
            this.startDate = x.startDate
            this.status = x.status
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Session = Session(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl] inside the given [block]
         */
        fun outputUrl(block: aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl.Builder.() -> kotlin.Unit) {
            this.outputUrl = aws.sdk.kotlin.services.ssm.model.SessionManagerOutputUrl.invoke(block)
        }
    }
}
