// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class StartAutomationExecutionRequest private constructor(builder: Builder) {
    /**
     * User-provided idempotency token. The token must be unique, is case insensitive, enforces the
     * UUID format, and can't be reused.
     */
    val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the SSM document to run. This can be a public document or a custom document. To
     * run a shared document belonging to another account, specify the document ARN. For more
     * information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM documents
     * in the Amazon Web Services Systems Manager User Guide.
     */
    val documentName: kotlin.String? = builder.documentName
    /**
     * The version of the Automation runbook to use for this execution.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The maximum number of targets allowed to run this task in parallel. You can specify a
     * number, such as 10, or a percentage, such as 10%. The default value is 10.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The number of errors that are allowed before the system stops running the automation on
     * additional targets. You can specify either an absolute number of errors, for example 10, or a
     * percentage of the target set, for example 10%. If you specify 3, for example, the system stops
     * running the automation when the fourth error is received. If you specify 0, then the system stops
     * running the automation on additional targets after the first error result is returned. If you run
     * an automation on 50 resources and set max-errors to 10%, then the system stops running the
     * automation on additional targets when the sixth error is received.
     * Executions that are already running an automation when max-errors is reached are allowed to
     * complete, but some of these executions may fail as well. If you need to ensure that there won't
     * be more than max-errors failed executions, set max-concurrency to 1 so the executions proceed one
     * at a time.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The execution mode of the automation. Valid modes include the following: Auto and
     * Interactive. The default mode is Auto.
     */
    val mode: aws.sdk.kotlin.services.ssm.model.ExecutionMode? = builder.mode
    /**
     * A key-value map of execution parameters, which match the declared parameters in the
     * Automation runbook.
     */
    val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * Optional metadata that you assign to a resource. You can specify a maximum of five tags for
     * an automation. Tags enable you to categorize a resource in different ways, such as by purpose,
     * owner, or environment. For example, you might want to tag an automation to identify an
     * environment or operating system. In this case, you could specify the following key-value
     * pairs:
     *
     *
     *
     * Key=environment,Value=test
     *
     *
     *
     * Key=OS,Value=Windows
     *
     *
     *
     * To add tags to an existing automation, use the AddTagsToResource
     * operation.
     */
    val tags: List<Tag>? = builder.tags
    /**
     * A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the
     * automation. Use this operation to start an automation in multiple Amazon Web Services Regions and multiple
     * Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts in the
     * Amazon Web Services Systems Manager User Guide.
     */
    val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps
     * can't be specified together.
     */
    val targetMaps: List<Map<String, List<String>>>? = builder.targetMaps
    /**
     * The name of the parameter used as the target resource for the rate-controlled execution.
     * Required if you specify targets.
     */
    val targetParameterName: kotlin.String? = builder.targetParameterName
    /**
     * A key-value mapping to target resources. Required if you specify TargetParameterName.
     */
    val targets: List<Target>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.StartAutomationExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartAutomationExecutionRequest(")
        append("clientToken=$clientToken,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("mode=$mode,")
        append("parameters=$parameters,")
        append("tags=$tags,")
        append("targetLocations=$targetLocations,")
        append("targetMaps=$targetMaps,")
        append("targetParameterName=$targetParameterName,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (documentName?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (mode?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targetMaps?.hashCode() ?: 0)
        result = 31 * result + (targetParameterName?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartAutomationExecutionRequest

        if (clientToken != other.clientToken) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (mode != other.mode) return false
        if (parameters != other.parameters) return false
        if (tags != other.tags) return false
        if (targetLocations != other.targetLocations) return false
        if (targetMaps != other.targetMaps) return false
        if (targetParameterName != other.targetParameterName) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.StartAutomationExecutionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * User-provided idempotency token. The token must be unique, is case insensitive, enforces the
         * UUID format, and can't be reused.
         */
        var clientToken: kotlin.String? = null
        /**
         * The name of the SSM document to run. This can be a public document or a custom document. To
         * run a shared document belonging to another account, specify the document ARN. For more
         * information about how to use shared documents, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM documents
         * in the Amazon Web Services Systems Manager User Guide.
         */
        var documentName: kotlin.String? = null
        /**
         * The version of the Automation runbook to use for this execution.
         */
        var documentVersion: kotlin.String? = null
        /**
         * The maximum number of targets allowed to run this task in parallel. You can specify a
         * number, such as 10, or a percentage, such as 10%. The default value is 10.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The number of errors that are allowed before the system stops running the automation on
         * additional targets. You can specify either an absolute number of errors, for example 10, or a
         * percentage of the target set, for example 10%. If you specify 3, for example, the system stops
         * running the automation when the fourth error is received. If you specify 0, then the system stops
         * running the automation on additional targets after the first error result is returned. If you run
         * an automation on 50 resources and set max-errors to 10%, then the system stops running the
         * automation on additional targets when the sixth error is received.
         * Executions that are already running an automation when max-errors is reached are allowed to
         * complete, but some of these executions may fail as well. If you need to ensure that there won't
         * be more than max-errors failed executions, set max-concurrency to 1 so the executions proceed one
         * at a time.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The execution mode of the automation. Valid modes include the following: Auto and
         * Interactive. The default mode is Auto.
         */
        var mode: aws.sdk.kotlin.services.ssm.model.ExecutionMode? = null
        /**
         * A key-value map of execution parameters, which match the declared parameters in the
         * Automation runbook.
         */
        var parameters: Map<String, List<String>>? = null
        /**
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for
         * an automation. Tags enable you to categorize a resource in different ways, such as by purpose,
         * owner, or environment. For example, you might want to tag an automation to identify an
         * environment or operating system. In this case, you could specify the following key-value
         * pairs:
         *
         *
         *
         * Key=environment,Value=test
         *
         *
         *
         * Key=OS,Value=Windows
         *
         *
         *
         * To add tags to an existing automation, use the AddTagsToResource
         * operation.
         */
        var tags: List<Tag>? = null
        /**
         * A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to run the
         * automation. Use this operation to start an automation in multiple Amazon Web Services Regions and multiple
         * Amazon Web Services accounts. For more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html">Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts in the
         * Amazon Web Services Systems Manager User Guide.
         */
        var targetLocations: List<TargetLocation>? = null
        /**
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps
         * can't be specified together.
         */
        var targetMaps: List<Map<String, List<String>>>? = null
        /**
         * The name of the parameter used as the target resource for the rate-controlled execution.
         * Required if you specify targets.
         */
        var targetParameterName: kotlin.String? = null
        /**
         * A key-value mapping to target resources. Required if you specify TargetParameterName.
         */
        var targets: List<Target>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.StartAutomationExecutionRequest) : this() {
            this.clientToken = x.clientToken
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.mode = x.mode
            this.parameters = x.parameters
            this.tags = x.tags
            this.targetLocations = x.targetLocations
            this.targetMaps = x.targetMaps
            this.targetParameterName = x.targetParameterName
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.StartAutomationExecutionRequest = StartAutomationExecutionRequest(this)
    }
}
