// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class StartSessionRequest private constructor(builder: Builder) {
    /**
     * The name of the SSM document to define the parameters and plugin settings for the session.
     * For example, SSM-SessionManagerRunShell. You can call the GetDocument API to verify the document exists before attempting to start a session.
     * If no document name is provided, a shell to the managed node is launched by default.
     */
    val documentName: kotlin.String? = builder.documentName
    /**
     * The values you want to specify for the parameters defined in the Session
     * document.
     */
    val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The reason for connecting to the instance. This value is included in the details for the
     * Amazon CloudWatch Events event created when you start the session.
     */
    val reason: kotlin.String? = builder.reason
    /**
     * The managed node to connect to for the session.
     */
    val target: kotlin.String? = builder.target

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.StartSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSessionRequest(")
        append("documentName=$documentName,")
        append("parameters=$parameters,")
        append("reason=$reason,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentName?.hashCode() ?: 0
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (reason?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSessionRequest

        if (documentName != other.documentName) return false
        if (parameters != other.parameters) return false
        if (reason != other.reason) return false
        if (target != other.target) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.StartSessionRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the SSM document to define the parameters and plugin settings for the session.
         * For example, SSM-SessionManagerRunShell. You can call the GetDocument API to verify the document exists before attempting to start a session.
         * If no document name is provided, a shell to the managed node is launched by default.
         */
        var documentName: kotlin.String? = null
        /**
         * The values you want to specify for the parameters defined in the Session
         * document.
         */
        var parameters: Map<String, List<String>>? = null
        /**
         * The reason for connecting to the instance. This value is included in the details for the
         * Amazon CloudWatch Events event created when you start the session.
         */
        var reason: kotlin.String? = null
        /**
         * The managed node to connect to for the session.
         */
        var target: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.StartSessionRequest) : this() {
            this.documentName = x.documentName
            this.parameters = x.parameters
            this.reason = x.reason
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.StartSessionRequest = StartSessionRequest(this)
    }
}
