// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Detailed information about an the execution state of an Automation step.
 */
class StepExecution private constructor(builder: Builder) {
    /**
     * The action this step performs. The action determines the behavior of the step.
     */
    val action: kotlin.String? = builder.action
    /**
     * If a step has finished execution, this contains the time the execution ended. If the step
     * hasn't yet concluded, this field isn't populated.
     */
    val executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionEndTime
    /**
     * If a step has begun execution, this contains the time the step started. If the step is in
     * Pending status, this field isn't populated.
     */
    val executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.executionStartTime
    /**
     * Information about the Automation failure.
     */
    val failureDetails: aws.sdk.kotlin.services.ssm.model.FailureDetails? = builder.failureDetails
    /**
     * If a step failed, this message explains why the execution failed.
     */
    val failureMessage: kotlin.String? = builder.failureMessage
    /**
     * Fully-resolved values passed into the step before execution.
     */
    val inputs: Map<String, String>? = builder.inputs
    /**
     * The flag which can be used to help decide whether the failure of current step leads to the
     * Automation failure.
     */
    val isCritical: kotlin.Boolean = builder.isCritical
    /**
     * The flag which can be used to end automation no matter whether the step succeeds or
     * fails.
     */
    val isEnd: kotlin.Boolean = builder.isEnd
    /**
     * The maximum number of tries to run the action of the step. The default value is
     * 1.
     */
    val maxAttempts: kotlin.Int = builder.maxAttempts
    /**
     * The next step after the step succeeds.
     */
    val nextStep: kotlin.String? = builder.nextStep
    /**
     * The action to take if the step fails. The default value is Abort.
     */
    val onFailure: kotlin.String? = builder.onFailure
    /**
     * Returned values from the execution of the step.
     */
    val outputs: Map<String, List<String>>? = builder.outputs
    /**
     * A user-specified list of parameters to override when running a step.
     */
    val overriddenParameters: Map<String, List<String>>? = builder.overriddenParameters
    /**
     * A message associated with the response code for an execution.
     */
    val response: kotlin.String? = builder.response
    /**
     * The response code returned by the execution of the step.
     */
    val responseCode: kotlin.String? = builder.responseCode
    /**
     * The unique ID of a step execution.
     */
    val stepExecutionId: kotlin.String? = builder.stepExecutionId
    /**
     * The name of this execution step.
     */
    val stepName: kotlin.String? = builder.stepName
    /**
     * The execution status for this step.
     */
    val stepStatus: aws.sdk.kotlin.services.ssm.model.AutomationExecutionStatus? = builder.stepStatus
    /**
     * The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation
     * execution.
     */
    val targetLocation: aws.sdk.kotlin.services.ssm.model.TargetLocation? = builder.targetLocation
    /**
     * The targets for the step execution.
     */
    val targets: List<Target>? = builder.targets
    /**
     * The timeout seconds of the step.
     */
    val timeoutSeconds: kotlin.Long = builder.timeoutSeconds
    /**
     * Strategies used when step fails, we support Continue and Abort. Abort will fail the
     * automation when the step fails. Continue will ignore the failure of current step and allow
     * automation to run the next step. With conditional branching, we add step:stepName to support the
     * automation to go to another specific step.
     */
    val validNextSteps: List<String>? = builder.validNextSteps

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.StepExecution = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StepExecution(")
        append("action=$action,")
        append("executionEndTime=$executionEndTime,")
        append("executionStartTime=$executionStartTime,")
        append("failureDetails=$failureDetails,")
        append("failureMessage=$failureMessage,")
        append("inputs=$inputs,")
        append("isCritical=$isCritical,")
        append("isEnd=$isEnd,")
        append("maxAttempts=$maxAttempts,")
        append("nextStep=$nextStep,")
        append("onFailure=$onFailure,")
        append("outputs=$outputs,")
        append("overriddenParameters=$overriddenParameters,")
        append("response=$response,")
        append("responseCode=$responseCode,")
        append("stepExecutionId=$stepExecutionId,")
        append("stepName=$stepName,")
        append("stepStatus=$stepStatus,")
        append("targetLocation=$targetLocation,")
        append("targets=$targets,")
        append("timeoutSeconds=$timeoutSeconds,")
        append("validNextSteps=$validNextSteps)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (executionEndTime?.hashCode() ?: 0)
        result = 31 * result + (executionStartTime?.hashCode() ?: 0)
        result = 31 * result + (failureDetails?.hashCode() ?: 0)
        result = 31 * result + (failureMessage?.hashCode() ?: 0)
        result = 31 * result + (inputs?.hashCode() ?: 0)
        result = 31 * result + (isCritical.hashCode())
        result = 31 * result + (isEnd.hashCode())
        result = 31 * result + (maxAttempts)
        result = 31 * result + (nextStep?.hashCode() ?: 0)
        result = 31 * result + (onFailure?.hashCode() ?: 0)
        result = 31 * result + (outputs?.hashCode() ?: 0)
        result = 31 * result + (overriddenParameters?.hashCode() ?: 0)
        result = 31 * result + (response?.hashCode() ?: 0)
        result = 31 * result + (responseCode?.hashCode() ?: 0)
        result = 31 * result + (stepExecutionId?.hashCode() ?: 0)
        result = 31 * result + (stepName?.hashCode() ?: 0)
        result = 31 * result + (stepStatus?.hashCode() ?: 0)
        result = 31 * result + (targetLocation?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (timeoutSeconds.hashCode())
        result = 31 * result + (validNextSteps?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StepExecution

        if (action != other.action) return false
        if (executionEndTime != other.executionEndTime) return false
        if (executionStartTime != other.executionStartTime) return false
        if (failureDetails != other.failureDetails) return false
        if (failureMessage != other.failureMessage) return false
        if (inputs != other.inputs) return false
        if (isCritical != other.isCritical) return false
        if (isEnd != other.isEnd) return false
        if (maxAttempts != other.maxAttempts) return false
        if (nextStep != other.nextStep) return false
        if (onFailure != other.onFailure) return false
        if (outputs != other.outputs) return false
        if (overriddenParameters != other.overriddenParameters) return false
        if (response != other.response) return false
        if (responseCode != other.responseCode) return false
        if (stepExecutionId != other.stepExecutionId) return false
        if (stepName != other.stepName) return false
        if (stepStatus != other.stepStatus) return false
        if (targetLocation != other.targetLocation) return false
        if (targets != other.targets) return false
        if (timeoutSeconds != other.timeoutSeconds) return false
        if (validNextSteps != other.validNextSteps) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.StepExecution = Builder(this).apply(block).build()

    class Builder {
        /**
         * The action this step performs. The action determines the behavior of the step.
         */
        var action: kotlin.String? = null
        /**
         * If a step has finished execution, this contains the time the execution ended. If the step
         * hasn't yet concluded, this field isn't populated.
         */
        var executionEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * If a step has begun execution, this contains the time the step started. If the step is in
         * Pending status, this field isn't populated.
         */
        var executionStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Information about the Automation failure.
         */
        var failureDetails: aws.sdk.kotlin.services.ssm.model.FailureDetails? = null
        /**
         * If a step failed, this message explains why the execution failed.
         */
        var failureMessage: kotlin.String? = null
        /**
         * Fully-resolved values passed into the step before execution.
         */
        var inputs: Map<String, String>? = null
        /**
         * The flag which can be used to help decide whether the failure of current step leads to the
         * Automation failure.
         */
        var isCritical: kotlin.Boolean = false
        /**
         * The flag which can be used to end automation no matter whether the step succeeds or
         * fails.
         */
        var isEnd: kotlin.Boolean = false
        /**
         * The maximum number of tries to run the action of the step. The default value is
         * 1.
         */
        var maxAttempts: kotlin.Int = 0
        /**
         * The next step after the step succeeds.
         */
        var nextStep: kotlin.String? = null
        /**
         * The action to take if the step fails. The default value is Abort.
         */
        var onFailure: kotlin.String? = null
        /**
         * Returned values from the execution of the step.
         */
        var outputs: Map<String, List<String>>? = null
        /**
         * A user-specified list of parameters to override when running a step.
         */
        var overriddenParameters: Map<String, List<String>>? = null
        /**
         * A message associated with the response code for an execution.
         */
        var response: kotlin.String? = null
        /**
         * The response code returned by the execution of the step.
         */
        var responseCode: kotlin.String? = null
        /**
         * The unique ID of a step execution.
         */
        var stepExecutionId: kotlin.String? = null
        /**
         * The name of this execution step.
         */
        var stepName: kotlin.String? = null
        /**
         * The execution status for this step.
         */
        var stepStatus: aws.sdk.kotlin.services.ssm.model.AutomationExecutionStatus? = null
        /**
         * The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation
         * execution.
         */
        var targetLocation: aws.sdk.kotlin.services.ssm.model.TargetLocation? = null
        /**
         * The targets for the step execution.
         */
        var targets: List<Target>? = null
        /**
         * The timeout seconds of the step.
         */
        var timeoutSeconds: kotlin.Long = 0L
        /**
         * Strategies used when step fails, we support Continue and Abort. Abort will fail the
         * automation when the step fails. Continue will ignore the failure of current step and allow
         * automation to run the next step. With conditional branching, we add step:stepName to support the
         * automation to go to another specific step.
         */
        var validNextSteps: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.StepExecution) : this() {
            this.action = x.action
            this.executionEndTime = x.executionEndTime
            this.executionStartTime = x.executionStartTime
            this.failureDetails = x.failureDetails
            this.failureMessage = x.failureMessage
            this.inputs = x.inputs
            this.isCritical = x.isCritical
            this.isEnd = x.isEnd
            this.maxAttempts = x.maxAttempts
            this.nextStep = x.nextStep
            this.onFailure = x.onFailure
            this.outputs = x.outputs
            this.overriddenParameters = x.overriddenParameters
            this.response = x.response
            this.responseCode = x.responseCode
            this.stepExecutionId = x.stepExecutionId
            this.stepName = x.stepName
            this.stepStatus = x.stepStatus
            this.targetLocation = x.targetLocation
            this.targets = x.targets
            this.timeoutSeconds = x.timeoutSeconds
            this.validNextSteps = x.validNextSteps
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.StepExecution = StepExecution(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.FailureDetails] inside the given [block]
         */
        fun failureDetails(block: aws.sdk.kotlin.services.ssm.model.FailureDetails.Builder.() -> kotlin.Unit) {
            this.failureDetails = aws.sdk.kotlin.services.ssm.model.FailureDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.TargetLocation] inside the given [block]
         */
        fun targetLocation(block: aws.sdk.kotlin.services.ssm.model.TargetLocation.Builder.() -> kotlin.Unit) {
            this.targetLocation = aws.sdk.kotlin.services.ssm.model.TargetLocation.invoke(block)
        }
    }
}
