// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



/**
 * An array of search criteria that targets managed nodes using a key-value pair that you
 * specify.
 *
 * One or more targets must be specified for maintenance window Run Command-type tasks.
 * Depending on the task, targets are optional for other maintenance window task types (Automation,
 * Lambda, and Step Functions). For more information about running tasks
 * that don't specify targets, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html">Registering
 * maintenance window tasks without targets in the
 * Amazon Web Services Systems Manager User Guide.
 *
 * Supported formats include the following.
 *
 *
 *
 * Key=InstanceIds,Values=<instance-id-1>,<instance-id-2>,<instance-id-3>
 *
 *
 *
 * Key=tag:<my-tag-key>,Values=<my-tag-value-1>,<my-tag-value-2>
 *
 *
 *
 * Key=tag-key,Values=<my-tag-key-1>,<my-tag-key-2>
 *
 *
 *
 * Run Command and Maintenance window targets only:
 * Key=resource-groups:Name,Values=<resource-group-name>
 *
 *
 *
 * Maintenance window targets only:
 * Key=resource-groups:ResourceTypeFilters,Values=<resource-type-1>,<resource-type-2>
 *
 *
 *
 * Automation targets only:
 * Key=ResourceGroup;Values=<resource-group-name>
 *
 *
 *
 * For example:
 *
 *
 *
 * Key=InstanceIds,Values=i-02573cafcfEXAMPLE,i-0471e04240EXAMPLE,i-07782c72faEXAMPLE
 *
 *
 *
 * Key=tag:CostCenter,Values=CostCenter1,CostCenter2,CostCenter3
 *
 *
 *
 * Key=tag-key,Values=Name,Instance-Type,CostCenter
 *
 *
 *
 * Run Command and Maintenance window targets only:
 * Key=resource-groups:Name,Values=ProductionResourceGroup
 *
 * This example demonstrates how to target all resources in the resource group ProductionResourceGroup in your maintenance window.
 *
 *
 * Maintenance window targets only:
 * Key=resource-groups:ResourceTypeFilters,Values=AWS::EC2::INSTANCE,AWS::EC2::VPC
 *
 * This example demonstrates how to target only Amazon Elastic Compute Cloud (Amazon EC2)
 * instances and VPCs in your maintenance window.
 *
 *
 * Automation targets only:
 * Key=ResourceGroup,Values=MyResourceGroup
 *
 *
 *
 * State Manager association targets only:
 * Key=InstanceIds,Values=*
 *
 * This example demonstrates how to target all managed instances in the Amazon Web Services Region where
 * the association was created.
 *
 *
 * For more information about how to send commands that target managed nodes using
 * Key,Value parameters, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-targeting">Targeting multiple instances in the Amazon Web Services Systems Manager User Guide.
 */
class Target private constructor(builder: Builder) {
    /**
     * User-defined criteria for sending commands that target managed nodes that meet the
     * criteria.
     */
    val key: kotlin.String? = builder.key
    /**
     * User-defined criteria that maps to Key. For example, if you specified
     * tag:ServerRole, you could specify value:WebServer to run a command on
     * instances that include EC2 tags of ServerRole,WebServer.
     * Depending on the type of target, the maximum number of values for a key might be lower than
     * the global maximum of 50.
     */
    val values: List<String>? = builder.values

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Target = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Target(")
        append("key=$key,")
        append("values=$values)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (values?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Target

        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Target = Builder(this).apply(block).build()

    class Builder {
        /**
         * User-defined criteria for sending commands that target managed nodes that meet the
         * criteria.
         */
        var key: kotlin.String? = null
        /**
         * User-defined criteria that maps to Key. For example, if you specified
         * tag:ServerRole, you could specify value:WebServer to run a command on
         * instances that include EC2 tags of ServerRole,WebServer.
         * Depending on the type of target, the maximum number of values for a key might be lower than
         * the global maximum of 50.
         */
        var values: List<String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Target) : this() {
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Target = Target(this)
    }
}
