// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class UpdateAssociationRequest private constructor(builder: Builder) {
    /**
     * By default, when you update an association, the system runs it immediately after it is
     * updated and then according to the schedule you specified. Specify this option if you don't want
     * an association to run immediately after you update it. This parameter isn't supported for rate
     * expressions.
     *
     * If you chose this option when you created an association and later you edit that association
     * or you make changes to the SSM document on which that association is based (by using the
     * Documents page in the console), State Manager applies the association at the next specified cron
     * interval. For example, if you chose the Latest version of an SSM document when you
     * created an association and you edit the association by choosing a different document version on
     * the Documents page, State Manager applies the association at the next specified cron interval if
     * you previously selected this option. If this option wasn't selected, State Manager immediately
     * runs the association.
     * You can reset this option. To do so, specify the no-apply-only-at-cron-interval
     * parameter when you update the association from the command line. This parameter forces the
     * association to run immediately after updating it and according to the interval specified.
     */
    val applyOnlyAtCronInterval: kotlin.Boolean = builder.applyOnlyAtCronInterval
    /**
     * The ID of the association you want to update.
     */
    val associationId: kotlin.String? = builder.associationId
    /**
     * The name of the association that you want to update.
     */
    val associationName: kotlin.String? = builder.associationName
    /**
     * This parameter is provided for concurrency control purposes. You must specify the latest
     * association version in the service. If you want to ensure that this request succeeds, either
     * specify $LATEST, or omit this parameter.
     */
    val associationVersion: kotlin.String? = builder.associationVersion
    /**
     * Choose the parameter that will define how your automation will branch out. This target is
     * required for associations that use an Automation runbook and target resources by using rate
     * controls. Automation is a capability of Amazon Web Services Systems Manager.
     */
    val automationTargetParameterName: kotlin.String? = builder.automationTargetParameterName
    /**
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to
     * gate your associations under. The associations only run when that change calendar is open. For
     * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
     * Calendar.
     */
    val calendarNames: List<String>? = builder.calendarNames
    /**
     * The severity level to assign to the association.
     */
    val complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = builder.complianceSeverity
    /**
     * The document version you want update for the association.
     *
     * State Manager doesn't support running associations that use a new version of a document if
     * that document is shared from another account. State Manager always runs the default
     * version of a document if shared from another account, even though the Systems Manager console shows that a
     * new version was processed. If you want to run an association using a new version of a document
     * shared form another account, you must set the document version to default.
     */
    val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The maximum number of targets allowed to run the association at the same time. You can
     * specify a number, for example 10, or a percentage of the target set, for example 10%. The default
     * value is 100%, which means all targets run the association at the same time.
     * If a new managed node starts and attempts to run an association while Systems Manager is running
     * MaxConcurrency associations, the association is allowed to run. During the next
     * association interval, the new managed node will process its association within the limit
     * specified for MaxConcurrency.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The number of errors that are allowed before the system stops sending requests to run the
     * association on additional targets. You can specify either an absolute number of errors, for
     * example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
     * the system stops sending requests when the fourth error is received. If you specify 0, then the
     * system stops sending requests after the first error is returned. If you run an association on 50
     * managed nodes and set MaxError to 10%, then the system stops sending the request
     * when the sixth error is received.
     * Executions that are already running an association when MaxErrors is reached
     * are allowed to complete, but some of these executions may fail as well. If you need to ensure
     * that there won't be more than max-errors failed executions, set MaxConcurrency to 1
     * so that executions proceed one at a time.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The name of the SSM Command document or Automation runbook that contains the configuration
     * information for the managed node.
     * You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
     * shared with you from another account.
     * For Systems Manager document (SSM document) that are shared with you from other Amazon Web Services accounts, you
     * must specify the complete SSM document ARN, in the following format:
     *
     * arn:aws:ssm:region:account-id:document/document-name
     *
     *
     * For example:
     *
     * arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document
     *
     * For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
     * to specify the document name. For example, AWS-ApplyPatchBaseline or
     * My-Document.
     */
    val name: kotlin.String? = builder.name
    /**
     * An S3 bucket where you want to store the results of this request.
     */
    val outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = builder.outputLocation
    /**
     * The parameters you want to update for the association. If you create a parameter using
     * Parameter Store, a capability of Amazon Web Services Systems Manager, you can reference the parameter using
     * {{ssm:parameter-name}}.
     */
    val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The cron expression used to schedule the association that you want to update.
     */
    val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * Number of days to wait after the scheduled day to run an association. For example, if you
     * specified a cron schedule of cron(0 0 ? * THU#2 *), you could specify an offset of 3
     * to run the association each Sunday after the second Thursday of the month. For more information about cron schedules for associations, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html">Reference: Cron and rate expressions for Systems Manager in the Amazon Web Services Systems Manager User Guide.
     *
     * To use offsets, you must specify the ApplyOnlyAtCronInterval parameter. This
     * option tells the system not to run an association immediately after you create it.
     */
    val scheduleOffset: kotlin.Int = builder.scheduleOffset
    /**
     * The mode for generating association compliance. You can specify AUTO or
     * MANUAL. In AUTO mode, the system uses the status of the association
     * execution to determine the compliance status. If the association execution runs successfully,
     * then the association is COMPLIANT. If the association execution doesn't run
     * successfully, the association is NON-COMPLIANT.
     * In MANUAL mode, you must specify the AssociationId as a parameter
     * for the PutComplianceItems API operation. In this case, compliance data isn't
     * managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
     * PutComplianceItems API operation.
     * By default, all associations use AUTO mode.
     */
    val syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = builder.syncCompliance
    /**
     * A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
     * association. Use this action to update an association in multiple Regions and multiple
     * accounts.
     */
    val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * The targets of the association.
     */
    val targets: List<Target>? = builder.targets

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAssociationRequest(")
        append("applyOnlyAtCronInterval=$applyOnlyAtCronInterval,")
        append("associationId=$associationId,")
        append("associationName=$associationName,")
        append("associationVersion=$associationVersion,")
        append("automationTargetParameterName=$automationTargetParameterName,")
        append("calendarNames=$calendarNames,")
        append("complianceSeverity=$complianceSeverity,")
        append("documentVersion=$documentVersion,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("outputLocation=$outputLocation,")
        append("parameters=*** Sensitive Data Redacted ***,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleOffset=$scheduleOffset,")
        append("syncCompliance=$syncCompliance,")
        append("targetLocations=$targetLocations,")
        append("targets=$targets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = applyOnlyAtCronInterval.hashCode()
        result = 31 * result + (associationId?.hashCode() ?: 0)
        result = 31 * result + (associationName?.hashCode() ?: 0)
        result = 31 * result + (associationVersion?.hashCode() ?: 0)
        result = 31 * result + (automationTargetParameterName?.hashCode() ?: 0)
        result = 31 * result + (calendarNames?.hashCode() ?: 0)
        result = 31 * result + (complianceSeverity?.hashCode() ?: 0)
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleOffset)
        result = 31 * result + (syncCompliance?.hashCode() ?: 0)
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAssociationRequest

        if (applyOnlyAtCronInterval != other.applyOnlyAtCronInterval) return false
        if (associationId != other.associationId) return false
        if (associationName != other.associationName) return false
        if (associationVersion != other.associationVersion) return false
        if (automationTargetParameterName != other.automationTargetParameterName) return false
        if (calendarNames != other.calendarNames) return false
        if (complianceSeverity != other.complianceSeverity) return false
        if (documentVersion != other.documentVersion) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (outputLocation != other.outputLocation) return false
        if (parameters != other.parameters) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (syncCompliance != other.syncCompliance) return false
        if (targetLocations != other.targetLocations) return false
        if (targets != other.targets) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateAssociationRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * By default, when you update an association, the system runs it immediately after it is
         * updated and then according to the schedule you specified. Specify this option if you don't want
         * an association to run immediately after you update it. This parameter isn't supported for rate
         * expressions.
         *
         * If you chose this option when you created an association and later you edit that association
         * or you make changes to the SSM document on which that association is based (by using the
         * Documents page in the console), State Manager applies the association at the next specified cron
         * interval. For example, if you chose the Latest version of an SSM document when you
         * created an association and you edit the association by choosing a different document version on
         * the Documents page, State Manager applies the association at the next specified cron interval if
         * you previously selected this option. If this option wasn't selected, State Manager immediately
         * runs the association.
         * You can reset this option. To do so, specify the no-apply-only-at-cron-interval
         * parameter when you update the association from the command line. This parameter forces the
         * association to run immediately after updating it and according to the interval specified.
         */
        var applyOnlyAtCronInterval: kotlin.Boolean = false
        /**
         * The ID of the association you want to update.
         */
        var associationId: kotlin.String? = null
        /**
         * The name of the association that you want to update.
         */
        var associationName: kotlin.String? = null
        /**
         * This parameter is provided for concurrency control purposes. You must specify the latest
         * association version in the service. If you want to ensure that this request succeeds, either
         * specify $LATEST, or omit this parameter.
         */
        var associationVersion: kotlin.String? = null
        /**
         * Choose the parameter that will define how your automation will branch out. This target is
         * required for associations that use an Automation runbook and target resources by using rate
         * controls. Automation is a capability of Amazon Web Services Systems Manager.
         */
        var automationTargetParameterName: kotlin.String? = null
        /**
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents you want to
         * gate your associations under. The associations only run when that change calendar is open. For
         * more information, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web Services Systems Manager Change
         * Calendar.
         */
        var calendarNames: List<String>? = null
        /**
         * The severity level to assign to the association.
         */
        var complianceSeverity: aws.sdk.kotlin.services.ssm.model.AssociationComplianceSeverity? = null
        /**
         * The document version you want update for the association.
         *
         * State Manager doesn't support running associations that use a new version of a document if
         * that document is shared from another account. State Manager always runs the default
         * version of a document if shared from another account, even though the Systems Manager console shows that a
         * new version was processed. If you want to run an association using a new version of a document
         * shared form another account, you must set the document version to default.
         */
        var documentVersion: kotlin.String? = null
        /**
         * The maximum number of targets allowed to run the association at the same time. You can
         * specify a number, for example 10, or a percentage of the target set, for example 10%. The default
         * value is 100%, which means all targets run the association at the same time.
         * If a new managed node starts and attempts to run an association while Systems Manager is running
         * MaxConcurrency associations, the association is allowed to run. During the next
         * association interval, the new managed node will process its association within the limit
         * specified for MaxConcurrency.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The number of errors that are allowed before the system stops sending requests to run the
         * association on additional targets. You can specify either an absolute number of errors, for
         * example 10, or a percentage of the target set, for example 10%. If you specify 3, for example,
         * the system stops sending requests when the fourth error is received. If you specify 0, then the
         * system stops sending requests after the first error is returned. If you run an association on 50
         * managed nodes and set MaxError to 10%, then the system stops sending the request
         * when the sixth error is received.
         * Executions that are already running an association when MaxErrors is reached
         * are allowed to complete, but some of these executions may fail as well. If you need to ensure
         * that there won't be more than max-errors failed executions, set MaxConcurrency to 1
         * so that executions proceed one at a time.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The name of the SSM Command document or Automation runbook that contains the configuration
         * information for the managed node.
         * You can specify Amazon Web Services-predefined documents, documents you created, or a document that is
         * shared with you from another account.
         * For Systems Manager document (SSM document) that are shared with you from other Amazon Web Services accounts, you
         * must specify the complete SSM document ARN, in the following format:
         *
         * arn:aws:ssm:region:account-id:document/document-name
         *
         *
         * For example:
         *
         * arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document
         *
         * For Amazon Web Services-predefined documents and SSM documents you created in your account, you only need
         * to specify the document name. For example, AWS-ApplyPatchBaseline or
         * My-Document.
         */
        var name: kotlin.String? = null
        /**
         * An S3 bucket where you want to store the results of this request.
         */
        var outputLocation: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation? = null
        /**
         * The parameters you want to update for the association. If you create a parameter using
         * Parameter Store, a capability of Amazon Web Services Systems Manager, you can reference the parameter using
         * {{ssm:parameter-name}}.
         */
        var parameters: Map<String, List<String>>? = null
        /**
         * The cron expression used to schedule the association that you want to update.
         */
        var scheduleExpression: kotlin.String? = null
        /**
         * Number of days to wait after the scheduled day to run an association. For example, if you
         * specified a cron schedule of cron(0 0 ? * THU#2 *), you could specify an offset of 3
         * to run the association each Sunday after the second Thursday of the month. For more information about cron schedules for associations, see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/reference-cron-and-rate-expressions.html">Reference: Cron and rate expressions for Systems Manager in the Amazon Web Services Systems Manager User Guide.
         *
         * To use offsets, you must specify the ApplyOnlyAtCronInterval parameter. This
         * option tells the system not to run an association immediately after you create it.
         */
        var scheduleOffset: kotlin.Int = 0
        /**
         * The mode for generating association compliance. You can specify AUTO or
         * MANUAL. In AUTO mode, the system uses the status of the association
         * execution to determine the compliance status. If the association execution runs successfully,
         * then the association is COMPLIANT. If the association execution doesn't run
         * successfully, the association is NON-COMPLIANT.
         * In MANUAL mode, you must specify the AssociationId as a parameter
         * for the PutComplianceItems API operation. In this case, compliance data isn't
         * managed by State Manager, a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
         * PutComplianceItems API operation.
         * By default, all associations use AUTO mode.
         */
        var syncCompliance: aws.sdk.kotlin.services.ssm.model.AssociationSyncCompliance? = null
        /**
         * A location is a combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
         * association. Use this action to update an association in multiple Regions and multiple
         * accounts.
         */
        var targetLocations: List<TargetLocation>? = null
        /**
         * The targets of the association.
         */
        var targets: List<Target>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateAssociationRequest) : this() {
            this.applyOnlyAtCronInterval = x.applyOnlyAtCronInterval
            this.associationId = x.associationId
            this.associationName = x.associationName
            this.associationVersion = x.associationVersion
            this.automationTargetParameterName = x.automationTargetParameterName
            this.calendarNames = x.calendarNames
            this.complianceSeverity = x.complianceSeverity
            this.documentVersion = x.documentVersion
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.outputLocation = x.outputLocation
            this.parameters = x.parameters
            this.scheduleExpression = x.scheduleExpression
            this.scheduleOffset = x.scheduleOffset
            this.syncCompliance = x.syncCompliance
            this.targetLocations = x.targetLocations
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateAssociationRequest = UpdateAssociationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation] inside the given [block]
         */
        fun outputLocation(block: aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.ssm.model.InstanceAssociationOutputLocation.invoke(block)
        }
    }
}
