// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model



class UpdateMaintenanceWindowTaskResponse private constructor(builder: Builder) {
    /**
     * The specification for whether tasks should continue to run after the cutoff time specified
     * in the maintenance windows is reached.
     */
    val cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = builder.cutoffBehavior
    /**
     * The updated task description.
     */
    val description: kotlin.String? = builder.description
    /**
     * The updated logging information in Amazon S3.
     *
     *
     * LoggingInfo has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
     * OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters structure.
     * For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
     * window task types, see MaintenanceWindowTaskInvocationParameters.
     */
    val loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = builder.loggingInfo
    /**
     * The updated MaxConcurrency value.
     */
    val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The updated MaxErrors value.
     */
    val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The updated task name.
     */
    val name: kotlin.String? = builder.name
    /**
     * The updated priority value.
     */
    val priority: kotlin.Int = builder.priority
    /**
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service
     * (Amazon SNS) notifications for maintenance window Run Command tasks.
     */
    val serviceRoleArn: kotlin.String? = builder.serviceRoleArn
    /**
     * The updated target values.
     */
    val targets: List<Target>? = builder.targets
    /**
     * The updated task ARN value.
     */
    val taskArn: kotlin.String? = builder.taskArn
    /**
     * The updated parameter values.
     */
    val taskInvocationParameters: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters? = builder.taskInvocationParameters
    /**
     * The updated parameter values.
     *
     *
     * TaskParameters has been deprecated. To specify parameters to pass to a task when it runs,
     * instead use the Parameters option in the TaskInvocationParameters structure. For information
     * about how Systems Manager handles these options for the supported maintenance window task
     * types, see MaintenanceWindowTaskInvocationParameters.
     */
    val taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = builder.taskParameters
    /**
     * The ID of the maintenance window that was updated.
     */
    val windowId: kotlin.String? = builder.windowId
    /**
     * The task ID of the maintenance window that was updated.
     */
    val windowTaskId: kotlin.String? = builder.windowTaskId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMaintenanceWindowTaskResponse(")
        append("cutoffBehavior=$cutoffBehavior,")
        append("description=*** Sensitive Data Redacted ***,")
        append("loggingInfo=$loggingInfo,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("name=$name,")
        append("priority=$priority,")
        append("serviceRoleArn=$serviceRoleArn,")
        append("targets=$targets,")
        append("taskArn=$taskArn,")
        append("taskInvocationParameters=$taskInvocationParameters,")
        append("taskParameters=*** Sensitive Data Redacted ***,")
        append("windowId=$windowId,")
        append("windowTaskId=$windowTaskId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cutoffBehavior?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (loggingInfo?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (priority)
        result = 31 * result + (serviceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (taskArn?.hashCode() ?: 0)
        result = 31 * result + (taskInvocationParameters?.hashCode() ?: 0)
        result = 31 * result + (taskParameters?.hashCode() ?: 0)
        result = 31 * result + (windowId?.hashCode() ?: 0)
        result = 31 * result + (windowTaskId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMaintenanceWindowTaskResponse

        if (cutoffBehavior != other.cutoffBehavior) return false
        if (description != other.description) return false
        if (loggingInfo != other.loggingInfo) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (name != other.name) return false
        if (priority != other.priority) return false
        if (serviceRoleArn != other.serviceRoleArn) return false
        if (targets != other.targets) return false
        if (taskArn != other.taskArn) return false
        if (taskInvocationParameters != other.taskInvocationParameters) return false
        if (taskParameters != other.taskParameters) return false
        if (windowId != other.windowId) return false
        if (windowTaskId != other.windowTaskId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The specification for whether tasks should continue to run after the cutoff time specified
         * in the maintenance windows is reached.
         */
        var cutoffBehavior: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskCutoffBehavior? = null
        /**
         * The updated task description.
         */
        var description: kotlin.String? = null
        /**
         * The updated logging information in Amazon S3.
         *
         *
         * LoggingInfo has been deprecated. To specify an Amazon Simple Storage Service (Amazon S3) bucket to contain logs, instead use the
         * OutputS3BucketName and OutputS3KeyPrefix options in the TaskInvocationParameters structure.
         * For information about how Amazon Web Services Systems Manager handles these options for the supported maintenance
         * window task types, see MaintenanceWindowTaskInvocationParameters.
         */
        var loggingInfo: aws.sdk.kotlin.services.ssm.model.LoggingInfo? = null
        /**
         * The updated MaxConcurrency value.
         */
        var maxConcurrency: kotlin.String? = null
        /**
         * The updated MaxErrors value.
         */
        var maxErrors: kotlin.String? = null
        /**
         * The updated task name.
         */
        var name: kotlin.String? = null
        /**
         * The updated priority value.
         */
        var priority: kotlin.Int = 0
        /**
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) service role to use to publish Amazon Simple Notification Service
         * (Amazon SNS) notifications for maintenance window Run Command tasks.
         */
        var serviceRoleArn: kotlin.String? = null
        /**
         * The updated target values.
         */
        var targets: List<Target>? = null
        /**
         * The updated task ARN value.
         */
        var taskArn: kotlin.String? = null
        /**
         * The updated parameter values.
         */
        var taskInvocationParameters: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters? = null
        /**
         * The updated parameter values.
         *
         *
         * TaskParameters has been deprecated. To specify parameters to pass to a task when it runs,
         * instead use the Parameters option in the TaskInvocationParameters structure. For information
         * about how Systems Manager handles these options for the supported maintenance window task
         * types, see MaintenanceWindowTaskInvocationParameters.
         */
        var taskParameters: Map<String, MaintenanceWindowTaskParameterValueExpression>? = null
        /**
         * The ID of the maintenance window that was updated.
         */
        var windowId: kotlin.String? = null
        /**
         * The task ID of the maintenance window that was updated.
         */
        var windowTaskId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse) : this() {
            this.cutoffBehavior = x.cutoffBehavior
            this.description = x.description
            this.loggingInfo = x.loggingInfo
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.name = x.name
            this.priority = x.priority
            this.serviceRoleArn = x.serviceRoleArn
            this.targets = x.targets
            this.taskArn = x.taskArn
            this.taskInvocationParameters = x.taskInvocationParameters
            this.taskParameters = x.taskParameters
            this.windowId = x.windowId
            this.windowTaskId = x.windowTaskId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateMaintenanceWindowTaskResponse = UpdateMaintenanceWindowTaskResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.LoggingInfo] inside the given [block]
         */
        fun loggingInfo(block: aws.sdk.kotlin.services.ssm.model.LoggingInfo.Builder.() -> kotlin.Unit) {
            this.loggingInfo = aws.sdk.kotlin.services.ssm.model.LoggingInfo.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters] inside the given [block]
         */
        fun taskInvocationParameters(block: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters.Builder.() -> kotlin.Unit) {
            this.taskInvocationParameters = aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskInvocationParameters.invoke(block)
        }
    }
}
