// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.AddTagsToResourceResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class AddTagsToResourceOperationDeserializer: HttpDeserialize<AddTagsToResourceResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AddTagsToResourceResponse {
        if (!response.status.isSuccess()) {
            throwAddTagsToResourceError(context, response)
        }
        val builder = AddTagsToResourceResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwAddTagsToResourceError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidResourceId" -> InvalidResourceIdDeserializer().deserialize(context, wrappedResponse)
        "InvalidResourceType" -> InvalidResourceTypeDeserializer().deserialize(context, wrappedResponse)
        "TooManyTagsError" -> TooManyTagsErrorDeserializer().deserialize(context, wrappedResponse)
        "TooManyUpdates" -> TooManyUpdatesDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
