// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.services.ssm.model.CreateActivationRequest
import aws.sdk.kotlin.services.ssm.model.RegistrationMetadataItem
import aws.sdk.kotlin.services.ssm.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateActivationOperationSerializer: HttpSerialize<CreateActivationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateActivationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateActivationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateActivationOperationBody(context: ExecutionContext, input: CreateActivationRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEFAULTINSTANCENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DefaultInstanceName"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val EXPIRATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExpirationDate"))
    val IAMROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IamRole"))
    val REGISTRATIONLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("RegistrationLimit"))
    val REGISTRATIONMETADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RegistrationMetadata"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFAULTINSTANCENAME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(EXPIRATIONDATE_DESCRIPTOR)
        field(IAMROLE_DESCRIPTOR)
        field(REGISTRATIONLIMIT_DESCRIPTOR)
        field(REGISTRATIONMETADATA_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.defaultInstanceName?.let { field(DEFAULTINSTANCENAME_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.expirationDate?.let { field(EXPIRATIONDATE_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.iamRole?.let { field(IAMROLE_DESCRIPTOR, it) }
        if (input.registrationLimit != 0) field(REGISTRATIONLIMIT_DESCRIPTOR, input.registrationLimit)
        if (input.registrationMetadata != null) {
            listField(REGISTRATIONMETADATA_DESCRIPTOR) {
                for (el0 in input.registrationMetadata) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRegistrationMetadataItemDocument))
                }
            }
        }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
