// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.AssociationDescription
import aws.sdk.kotlin.services.ssm.model.CreateAssociationBatchResponse
import aws.sdk.kotlin.services.ssm.model.FailedCreateAssociation
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateAssociationBatchOperationDeserializer: HttpDeserialize<CreateAssociationBatchResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateAssociationBatchResponse {
        if (!response.status.isSuccess()) {
            throwCreateAssociationBatchError(context, response)
        }
        val builder = CreateAssociationBatchResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAssociationBatchOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateAssociationBatchError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AssociationLimitExceeded" -> AssociationLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "DuplicateInstanceId" -> DuplicateInstanceIdDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedResponse)
        "InvalidDocumentVersion" -> InvalidDocumentVersionDeserializer().deserialize(context, wrappedResponse)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedResponse)
        "InvalidOutputLocation" -> InvalidOutputLocationDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameters" -> InvalidParametersDeserializer().deserialize(context, wrappedResponse)
        "InvalidSchedule" -> InvalidScheduleDeserializer().deserialize(context, wrappedResponse)
        "InvalidTarget" -> InvalidTargetDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedPlatformType" -> UnsupportedPlatformTypeDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAssociationBatchOperationBody(builder: CreateAssociationBatchResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Failed"))
    val SUCCESSFUL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Successful"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILED_DESCRIPTOR)
        field(SUCCESSFUL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILED_DESCRIPTOR.index -> builder.failed =
                    deserializer.deserializeList(FAILED_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedCreateAssociation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedCreateAssociationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFUL_DESCRIPTOR.index -> builder.successful =
                    deserializer.deserializeList(SUCCESSFUL_DESCRIPTOR) {
                        val col0 = mutableListOf<AssociationDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssociationDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
