// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.services.ssm.model.CreateOpsItemRequest
import aws.sdk.kotlin.services.ssm.model.OpsItemDataValue
import aws.sdk.kotlin.services.ssm.model.OpsItemNotification
import aws.sdk.kotlin.services.ssm.model.RelatedOpsItem
import aws.sdk.kotlin.services.ssm.model.Tag
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CreateOpsItemOperationSerializer: HttpSerialize<CreateOpsItemRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateOpsItemRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeCreateOpsItemOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeCreateOpsItemOperationBody(context: ExecutionContext, input: CreateOpsItemRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACTUALENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ActualEndTime"))
    val ACTUALSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ActualStartTime"))
    val CATEGORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Category"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val NOTIFICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Notifications"))
    val OPERATIONALDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("OperationalData"))
    val OPSITEMTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OpsItemType"))
    val PLANNEDENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("PlannedEndTime"))
    val PLANNEDSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("PlannedStartTime"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Priority"))
    val RELATEDOPSITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RelatedOpsItems"))
    val SEVERITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Severity"))
    val SOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Source"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Tags"))
    val TITLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Title"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTUALENDTIME_DESCRIPTOR)
        field(ACTUALSTARTTIME_DESCRIPTOR)
        field(CATEGORY_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(NOTIFICATIONS_DESCRIPTOR)
        field(OPERATIONALDATA_DESCRIPTOR)
        field(OPSITEMTYPE_DESCRIPTOR)
        field(PLANNEDENDTIME_DESCRIPTOR)
        field(PLANNEDSTARTTIME_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(RELATEDOPSITEMS_DESCRIPTOR)
        field(SEVERITY_DESCRIPTOR)
        field(SOURCE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TITLE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.actualEndTime?.let { field(ACTUALENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.actualStartTime?.let { field(ACTUALSTARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.category?.let { field(CATEGORY_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        if (input.notifications != null) {
            listField(NOTIFICATIONS_DESCRIPTOR) {
                for (el0 in input.notifications) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeOpsItemNotificationDocument))
                }
            }
        }
        if (input.operationalData != null) {
            mapField(OPERATIONALDATA_DESCRIPTOR) {
                input.operationalData.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeOpsItemDataValueDocument)) }
            }
        }
        input.opsItemType?.let { field(OPSITEMTYPE_DESCRIPTOR, it) }
        input.plannedEndTime?.let { field(PLANNEDENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.plannedStartTime?.let { field(PLANNEDSTARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.priority?.let { field(PRIORITY_DESCRIPTOR, it) }
        if (input.relatedOpsItems != null) {
            listField(RELATEDOPSITEMS_DESCRIPTOR) {
                for (el0 in input.relatedOpsItems) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeRelatedOpsItemDocument))
                }
            }
        }
        input.severity?.let { field(SEVERITY_DESCRIPTOR, it) }
        input.source?.let { field(SOURCE_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.title?.let { field(TITLE_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
