// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse
import aws.sdk.kotlin.services.ssm.model.EffectivePatch
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeEffectivePatchesForPatchBaselineOperationDeserializer: HttpDeserialize<DescribeEffectivePatchesForPatchBaselineResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEffectivePatchesForPatchBaselineResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEffectivePatchesForPatchBaselineError(context, response)
        }
        val builder = DescribeEffectivePatchesForPatchBaselineResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEffectivePatchesForPatchBaselineOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEffectivePatchesForPatchBaselineError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidResourceId" -> InvalidResourceIdDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedOperatingSystem" -> UnsupportedOperatingSystemDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEffectivePatchesForPatchBaselineOperationBody(builder: DescribeEffectivePatchesForPatchBaselineResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EFFECTIVEPATCHES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EffectivePatches"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EFFECTIVEPATCHES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EFFECTIVEPATCHES_DESCRIPTOR.index -> builder.effectivePatches =
                    deserializer.deserializeList(EFFECTIVEPATCHES_DESCRIPTOR) {
                        val col0 = mutableListOf<EffectivePatch>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEffectivePatchDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
