// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse
import aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecution
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeMaintenanceWindowExecutionsOperationDeserializer: HttpDeserialize<DescribeMaintenanceWindowExecutionsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeMaintenanceWindowExecutionsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeMaintenanceWindowExecutionsError(context, response)
        }
        val builder = DescribeMaintenanceWindowExecutionsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeMaintenanceWindowExecutionsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeMaintenanceWindowExecutionsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeMaintenanceWindowExecutionsOperationBody(builder: DescribeMaintenanceWindowExecutionsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val WINDOWEXECUTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WindowExecutions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(WINDOWEXECUTIONS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                WINDOWEXECUTIONS_DESCRIPTOR.index -> builder.windowExecutions =
                    deserializer.deserializeList(WINDOWEXECUTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<MaintenanceWindowExecution>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeMaintenanceWindowExecutionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
