// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.services.ssm.model.GetInventoryRequest
import aws.sdk.kotlin.services.ssm.model.InventoryAggregator
import aws.sdk.kotlin.services.ssm.model.InventoryFilter
import aws.sdk.kotlin.services.ssm.model.ResultAttribute
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetInventoryOperationSerializer: HttpSerialize<GetInventoryRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetInventoryRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeGetInventoryOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeGetInventoryOperationBody(context: ExecutionContext, input: GetInventoryRequest): ByteArray {
    val serializer = JsonSerializer()
    val AGGREGATORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Aggregators"))
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESULTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResultAttributes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AGGREGATORS_DESCRIPTOR)
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESULTATTRIBUTES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.aggregators != null) {
            listField(AGGREGATORS_DESCRIPTOR) {
                for (el0 in input.aggregators) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInventoryAggregatorDocument))
                }
            }
        }
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeInventoryFilterDocument))
                }
            }
        }
        if (input.maxResults != 0) field(MAXRESULTS_DESCRIPTOR, input.maxResults)
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        if (input.resultAttributes != null) {
            listField(RESULTATTRIBUTES_DESCRIPTOR) {
                for (el0 in input.resultAttributes) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeResultAttributeDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
