// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.GetOpsSummaryResponse
import aws.sdk.kotlin.services.ssm.model.OpsEntity
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetOpsSummaryOperationDeserializer: HttpDeserialize<GetOpsSummaryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetOpsSummaryResponse {
        if (!response.status.isSuccess()) {
            throwGetOpsSummaryError(context, response)
        }
        val builder = GetOpsSummaryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetOpsSummaryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetOpsSummaryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidAggregatorException" -> InvalidAggregatorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidFilter" -> InvalidFilterDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedResponse)
        "InvalidTypeNameException" -> InvalidTypeNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceDataSyncNotFoundException" -> ResourceDataSyncNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetOpsSummaryOperationBody(builder: GetOpsSummaryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENTITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Entities"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTITIES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENTITIES_DESCRIPTOR.index -> builder.entities =
                    deserializer.deserializeList(ENTITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<OpsEntity>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeOpsEntityDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
