// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.CommandInvocation
import aws.sdk.kotlin.services.ssm.model.ListCommandInvocationsResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListCommandInvocationsOperationDeserializer: HttpDeserialize<ListCommandInvocationsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListCommandInvocationsResponse {
        if (!response.status.isSuccess()) {
            throwListCommandInvocationsError(context, response)
        }
        val builder = ListCommandInvocationsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListCommandInvocationsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListCommandInvocationsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidCommandId" -> InvalidCommandIdDeserializer().deserialize(context, wrappedResponse)
        "InvalidFilterKey" -> InvalidFilterKeyDeserializer().deserialize(context, wrappedResponse)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListCommandInvocationsOperationBody(builder: ListCommandInvocationsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val COMMANDINVOCATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("CommandInvocations"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMANDINVOCATIONS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                COMMANDINVOCATIONS_DESCRIPTOR.index -> builder.commandInvocations =
                    deserializer.deserializeList(COMMANDINVOCATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<CommandInvocation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCommandInvocationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
