// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.services.ssm.model.ComplianceStringFilter
import aws.sdk.kotlin.services.ssm.model.ListComplianceItemsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListComplianceItemsOperationSerializer: HttpSerialize<ListComplianceItemsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListComplianceItemsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializeListComplianceItemsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeListComplianceItemsOperationBody(context: ExecutionContext, input: ListComplianceItemsRequest): ByteArray {
    val serializer = JsonSerializer()
    val FILTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Filters"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val RESOURCEIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourceIds"))
    val RESOURCETYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourceTypes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FILTERS_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(RESOURCEIDS_DESCRIPTOR)
        field(RESOURCETYPES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.filters != null) {
            listField(FILTERS_DESCRIPTOR) {
                for (el0 in input.filters) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeComplianceStringFilterDocument))
                }
            }
        }
        if (input.maxResults != 0) field(MAXRESULTS_DESCRIPTOR, input.maxResults)
        input.nextToken?.let { field(NEXTTOKEN_DESCRIPTOR, it) }
        if (input.resourceIds != null) {
            listField(RESOURCEIDS_DESCRIPTOR) {
                for (el0 in input.resourceIds) {
                    serializeString(el0)
                }
            }
        }
        if (input.resourceTypes != null) {
            listField(RESOURCETYPES_DESCRIPTOR) {
                for (el0 in input.resourceTypes) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
