// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.ListInventoryEntriesResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListInventoryEntriesOperationDeserializer: HttpDeserialize<ListInventoryEntriesResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListInventoryEntriesResponse {
        if (!response.status.isSuccess()) {
            throwListInventoryEntriesError(context, response)
        }
        val builder = ListInventoryEntriesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListInventoryEntriesOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListInventoryEntriesError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidFilter" -> InvalidFilterDeserializer().deserialize(context, wrappedResponse)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedResponse)
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedResponse)
        "InvalidTypeNameException" -> InvalidTypeNameExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListInventoryEntriesOperationBody(builder: ListInventoryEntriesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPTURETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CaptureTime"))
    val ENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Entries"))
    val ENTRIES_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val INSTANCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("InstanceId"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val SCHEMAVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SchemaVersion"))
    val TYPENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TypeName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPTURETIME_DESCRIPTOR)
        field(ENTRIES_DESCRIPTOR)
        field(INSTANCEID_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
        field(SCHEMAVERSION_DESCRIPTOR)
        field(TYPENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPTURETIME_DESCRIPTOR.index -> builder.captureTime = deserializeString()
                ENTRIES_DESCRIPTOR.index -> builder.entries =
                    deserializer.deserializeList(ENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<Map<String, String>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeMap(ENTRIES_C0_DESCRIPTOR) {
                                val map1 = mutableMapOf<String, String>()
                                while (hasNextEntry()) {
                                    val k1 = key()
                                    val v1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                    map1[k1] = v1
                                }
                                map1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                INSTANCEID_DESCRIPTOR.index -> builder.instanceId = deserializeString()
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                SCHEMAVERSION_DESCRIPTOR.index -> builder.schemaVersion = deserializeString()
                TYPENAME_DESCRIPTOR.index -> builder.typeName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
