// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.services.ssm.model.ComplianceExecutionSummary
import aws.sdk.kotlin.services.ssm.model.ComplianceItemEntry
import aws.sdk.kotlin.services.ssm.model.ComplianceUploadType
import aws.sdk.kotlin.services.ssm.model.PutComplianceItemsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutComplianceItemsOperationSerializer: HttpSerialize<PutComplianceItemsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutComplianceItemsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/"
        }

        val payload = serializePutComplianceItemsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializePutComplianceItemsOperationBody(context: ExecutionContext, input: PutComplianceItemsRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMPLIANCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ComplianceType"))
    val EXECUTIONSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExecutionSummary"))
    val ITEMCONTENTHASH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ItemContentHash"))
    val ITEMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Items"))
    val RESOURCEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceId"))
    val RESOURCETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ResourceType"))
    val UPLOADTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("UploadType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMPLIANCETYPE_DESCRIPTOR)
        field(EXECUTIONSUMMARY_DESCRIPTOR)
        field(ITEMCONTENTHASH_DESCRIPTOR)
        field(ITEMS_DESCRIPTOR)
        field(RESOURCEID_DESCRIPTOR)
        field(RESOURCETYPE_DESCRIPTOR)
        field(UPLOADTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.complianceType?.let { field(COMPLIANCETYPE_DESCRIPTOR, it) }
        input.executionSummary?.let { field(EXECUTIONSUMMARY_DESCRIPTOR, it, ::serializeComplianceExecutionSummaryDocument) }
        input.itemContentHash?.let { field(ITEMCONTENTHASH_DESCRIPTOR, it) }
        if (input.items != null) {
            listField(ITEMS_DESCRIPTOR) {
                for (el0 in input.items) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeComplianceItemEntryDocument))
                }
            }
        }
        input.resourceId?.let { field(RESOURCEID_DESCRIPTOR, it) }
        input.resourceType?.let { field(RESOURCETYPE_DESCRIPTOR, it) }
        input.uploadType?.let { field(UPLOADTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
