// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.PutInventoryResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutInventoryOperationDeserializer: HttpDeserialize<PutInventoryResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutInventoryResponse {
        if (!response.status.isSuccess()) {
            throwPutInventoryError(context, response)
        }
        val builder = PutInventoryResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutInventoryOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutInventoryError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CustomSchemaCountLimitExceededException" -> CustomSchemaCountLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedResponse)
        "InvalidInventoryItemContextException" -> InvalidInventoryItemContextExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidItemContentException" -> InvalidItemContentExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidTypeNameException" -> InvalidTypeNameExceptionDeserializer().deserialize(context, wrappedResponse)
        "ItemContentMismatchException" -> ItemContentMismatchExceptionDeserializer().deserialize(context, wrappedResponse)
        "ItemSizeLimitExceededException" -> ItemSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "SubTypeCountLimitExceededException" -> SubTypeCountLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "TotalSizeLimitExceededException" -> TotalSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedInventoryItemContextException" -> UnsupportedInventoryItemContextExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedInventorySchemaVersionException" -> UnsupportedInventorySchemaVersionExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutInventoryOperationBody(builder: PutInventoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
