// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.ParameterTier
import aws.sdk.kotlin.services.ssm.model.PutParameterResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutParameterOperationDeserializer: HttpDeserialize<PutParameterResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): PutParameterResponse {
        if (!response.status.isSuccess()) {
            throwPutParameterError(context, response)
        }
        val builder = PutParameterResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializePutParameterOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwPutParameterError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "HierarchyLevelLimitExceededException" -> HierarchyLevelLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "HierarchyTypeMismatchException" -> HierarchyTypeMismatchExceptionDeserializer().deserialize(context, wrappedResponse)
        "IncompatiblePolicyException" -> IncompatiblePolicyExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidAllowedPatternException" -> InvalidAllowedPatternExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidKeyId" -> InvalidKeyIdDeserializer().deserialize(context, wrappedResponse)
        "InvalidPolicyAttributeException" -> InvalidPolicyAttributeExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidPolicyTypeException" -> InvalidPolicyTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        "ParameterAlreadyExists" -> ParameterAlreadyExistsDeserializer().deserialize(context, wrappedResponse)
        "ParameterLimitExceeded" -> ParameterLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "ParameterMaxVersionLimitExceeded" -> ParameterMaxVersionLimitExceededDeserializer().deserialize(context, wrappedResponse)
        "ParameterPatternMismatchException" -> ParameterPatternMismatchExceptionDeserializer().deserialize(context, wrappedResponse)
        "PoliciesLimitExceededException" -> PoliciesLimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyUpdates" -> TooManyUpdatesDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedParameterType" -> UnsupportedParameterTypeDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutParameterOperationBody(builder: PutParameterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TIER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Tier"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("Version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TIER_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TIER_DESCRIPTOR.index -> builder.tier = deserializeString().let { ParameterTier.fromValue(it) }
                VERSION_DESCRIPTOR.index -> builder.version = deserializeLong()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
