// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.sdk.kotlin.services.ssm.model.StartSessionResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class StartSessionOperationDeserializer: HttpDeserialize<StartSessionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): StartSessionResponse {
        if (!response.status.isSuccess()) {
            throwStartSessionError(context, response)
        }
        val builder = StartSessionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeStartSessionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwStartSessionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedResponse)
        "TargetNotConnected" -> TargetNotConnectedDeserializer().deserialize(context, wrappedResponse)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeStartSessionOperationBody(builder: StartSessionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SessionId"))
    val STREAMURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StreamUrl"))
    val TOKENVALUE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TokenValue"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SESSIONID_DESCRIPTOR)
        field(STREAMURL_DESCRIPTOR)
        field(TOKENVALUE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                STREAMURL_DESCRIPTOR.index -> builder.streamUrl = deserializeString()
                TOKENVALUE_DESCRIPTOR.index -> builder.tokenValue = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
