// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.waiters

import aws.sdk.kotlin.services.ssm.SsmClient
import aws.sdk.kotlin.services.ssm.model.GetCommandInvocationRequest
import aws.sdk.kotlin.services.ssm.model.GetCommandInvocationResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.delay.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.ErrorTypeAcceptor
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType
import kotlin.time.Duration.Companion.milliseconds


suspend fun SsmClient.waitUntilCommandExecuted(request: GetCommandInvocationRequest): Outcome<GetCommandInvocationResponse> {
    val strategy = run {
        val delayOptions = ExponentialBackoffWithJitterOptions(
            initialDelay = 5_000.milliseconds,
            scaleFactor = 1.5,
            jitter = 1.0,
            maxBackoff = 120_000.milliseconds,
        )
        val delay = ExponentialBackoffWithJitter(delayOptions)

        val waiterOptions = StandardRetryStrategyOptions(maxAttempts = 20)
        StandardRetryStrategy(waiterOptions, InfiniteTokenBucket, delay)
    }

    val acceptors = listOf<Acceptor<GetCommandInvocationRequest, GetCommandInvocationResponse>>(
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it?.status
            status?.toString() == "Pending"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it?.status
            status?.toString() == "InProgress"
        },
        OutputAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide)) {
            val status = it?.status
            status?.toString() == "Delayed"
        },
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it?.status
            status?.toString() == "Success"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it?.status
            status?.toString() == "Cancelled"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it?.status
            status?.toString() == "TimedOut"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it?.status
            status?.toString() == "Failed"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it?.status
            status?.toString() == "Cancelling"
        },
        ErrorTypeAcceptor(RetryDirective.RetryError(RetryErrorType.ServerSide), "InvocationDoesNotExist"),
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getCommandInvocation(request) }
}

suspend fun SsmClient.waitUntilCommandExecuted(block: GetCommandInvocationRequest.Builder.() -> Unit): Outcome<GetCommandInvocationResponse> =
    waitUntilCommandExecuted(GetCommandInvocationRequest.Builder().apply(block).build())
