// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sso

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.sso.model.*
import aws.sdk.kotlin.services.sso.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "SSO"
const val ServiceApiVersion: String = "2019-06-10"
const val SdkVersion: String = "0.16.1-beta"

internal class DefaultSsoClient(override val config: SsoClient.Config) : SsoClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Returns the STS short-term credentials for a given role name that is assigned to the user.
     */
    override suspend fun getRoleCredentials(input: GetRoleCredentialsRequest): GetRoleCredentialsResponse {
        val op = SdkHttpOperation.build<GetRoleCredentialsRequest, GetRoleCredentialsResponse> {
            serializer = GetRoleCredentialsOperationSerializer()
            deserializer = GetRoleCredentialsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRoleCredentials"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Lists all roles that are assigned to the user for a given AWS account.
     */
    override suspend fun listAccountRoles(input: ListAccountRolesRequest): ListAccountRolesResponse {
        val op = SdkHttpOperation.build<ListAccountRolesRequest, ListAccountRolesResponse> {
            serializer = ListAccountRolesOperationSerializer()
            deserializer = ListAccountRolesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccountRoles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Lists all AWS accounts assigned to the user. These AWS accounts are assigned by the administrator of the account. For more information, see [Assign User Access](https://docs.aws.amazon.com/singlesignon/latest/userguide/useraccess.html#assignusers) in the *AWS SSO User Guide*. This operation returns a paginated response.
     */
    override suspend fun listAccounts(input: ListAccountsRequest): ListAccountsResponse {
        val op = SdkHttpOperation.build<ListAccountsRequest, ListAccountsResponse> {
            serializer = ListAccountsOperationSerializer()
            deserializer = ListAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    /**
     * Removes the client- and server-side session that is associated with the user.
     */
    override suspend fun logout(input: LogoutRequest): LogoutResponse {
        val op = SdkHttpOperation.build<LogoutRequest, LogoutResponse> {
            serializer = LogoutOperationSerializer()
            deserializer = LogoutOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "Logout"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "awsssoportal")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
