// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sso.internal

import aws.sdk.kotlin.runtime.ClientException
import aws.sdk.kotlin.runtime.endpoint.AwsEndpoint
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.endpoint.CredentialScope
import aws.sdk.kotlin.runtime.endpoint.internal.EndpointDefinition
import aws.sdk.kotlin.runtime.endpoint.internal.Partition
import aws.sdk.kotlin.runtime.endpoint.internal.resolveEndpoint

internal class DefaultEndpointResolver : AwsEndpointResolver {
    override suspend fun resolve(service: String, region: String): AwsEndpoint {
        return resolveEndpoint(servicePartitions, region) ?: throw ClientException("unable to resolve endpoint for region: $region")
    }
}

private val servicePartitions = listOf(
    Partition(
        id = "aws",
        regionRegex = Regex("^(us|eu|ap|sa|ca|me|af)\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "portal.sso.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
            "ap-southeast-1" to EndpointDefinition(
                hostname = "portal.sso.ap-southeast-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-1",),
            ),
            "ap-southeast-2" to EndpointDefinition(
                hostname = "portal.sso.ap-southeast-2.amazonaws.com",
                credentialScope = CredentialScope(region = "ap-southeast-2",),
            ),
            "ca-central-1" to EndpointDefinition(
                hostname = "portal.sso.ca-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "ca-central-1",),
            ),
            "eu-central-1" to EndpointDefinition(
                hostname = "portal.sso.eu-central-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-central-1",),
            ),
            "eu-west-1" to EndpointDefinition(
                hostname = "portal.sso.eu-west-1.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-1",),
            ),
            "eu-west-2" to EndpointDefinition(
                hostname = "portal.sso.eu-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "eu-west-2",),
            ),
            "us-east-1" to EndpointDefinition(
                hostname = "portal.sso.us-east-1.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-1",),
            ),
            "us-east-2" to EndpointDefinition(
                hostname = "portal.sso.us-east-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-east-2",),
            ),
            "us-west-2" to EndpointDefinition(
                hostname = "portal.sso.us-west-2.amazonaws.com",
                credentialScope = CredentialScope(region = "us-west-2",),
            ),
        )
    ),
    Partition(
        id = "aws-cn",
        regionRegex = Regex("^cn\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "portal.sso.{region}.amazonaws.com.cn",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso",
        regionRegex = Regex("^us\\-iso\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "portal.sso.{region}.c2s.ic.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-iso-b",
        regionRegex = Regex("^us\\-isob\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "portal.sso.{region}.sc2s.sgov.gov",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
    Partition(
        id = "aws-us-gov",
        regionRegex = Regex("^us\\-gov\\-\\w+\\-\\d+$"),
        partitionEndpoint = "",
        isRegionalized = true,
        defaults = EndpointDefinition(
            hostname = "portal.sso.{region}.amazonaws.com",
            protocols = listOf("https", ),
            signatureVersions = listOf("v4", ),
        ),
        endpoints = mapOf(
        )
    ),
)
