// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sso.paginators

import aws.sdk.kotlin.services.sso.SsoClient
import aws.sdk.kotlin.services.sso.model.ListAccountRolesRequest
import aws.sdk.kotlin.services.sso.model.ListAccountRolesResponse
import aws.sdk.kotlin.services.sso.model.ListAccountsRequest
import aws.sdk.kotlin.services.sso.model.ListAccountsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAccountRolesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountRolesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountRolesResponse]
 */
fun SsoClient.listAccountRolesPaginated(initialRequest: ListAccountRolesRequest): Flow<ListAccountRolesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountRolesPaginated.listAccountRoles(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountRolesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountRolesResponse]
 */
fun SsoClient.listAccountRolesPaginated(block: ListAccountRolesRequest.Builder.() -> Unit): Flow<ListAccountRolesResponse> =
    listAccountRolesPaginated(ListAccountRolesRequest.Builder().apply(block).build())

/**
 * Paginate over [ListAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsResponse]
 */
fun SsoClient.listAccountsPaginated(initialRequest: ListAccountsRequest): Flow<ListAccountsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountsPaginated.listAccounts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsResponse]
 */
fun SsoClient.listAccountsPaginated(block: ListAccountsRequest.Builder.() -> Unit): Flow<ListAccountsResponse> =
    listAccountsPaginated(ListAccountsRequest.Builder().apply(block).build())
