// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sso.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.sso.model.GetRoleCredentialsResponse
import aws.sdk.kotlin.services.sso.model.RoleCredentials
import aws.sdk.kotlin.services.sso.model.SsoException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRoleCredentialsOperationDeserializer: HttpDeserialize<GetRoleCredentialsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRoleCredentialsResponse {
        if (!response.status.isSuccess()) {
            throwGetRoleCredentialsError(context, response)
        }
        val builder = GetRoleCredentialsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRoleCredentialsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRoleCredentialsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsoException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsoException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRoleCredentialsOperationBody(builder: GetRoleCredentialsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ROLECREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("roleCredentials"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ROLECREDENTIALS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ROLECREDENTIALS_DESCRIPTOR.index -> builder.roleCredentials = deserializeRoleCredentialsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
