// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.ssoadmin.model.*
import aws.sdk.kotlin.services.ssoadmin.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "SSO Admin"
const val ServiceApiVersion: String = "2020-07-20"
const val SdkVersion: String = "0.16.0"

internal class DefaultSsoAdminClient(override val config: SsoAdminClient.Config) : SsoAdminClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Attaches an IAM managed policy ARN to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this operation. Calling `ProvisionPermissionSet` applies the corresponding IAM policy updates to all assigned accounts.
     */
    override suspend fun attachManagedPolicyToPermissionSet(input: AttachManagedPolicyToPermissionSetRequest): AttachManagedPolicyToPermissionSetResponse {
        val op = SdkHttpOperation.build<AttachManagedPolicyToPermissionSetRequest, AttachManagedPolicyToPermissionSetResponse> {
            serializer = AttachManagedPolicyToPermissionSetOperationSerializer()
            deserializer = AttachManagedPolicyToPermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AttachManagedPolicyToPermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Assigns access to a principal for a specified Amazon Web Services account using a specified permission set.
     *
     * The term *principal* here refers to a user or group that is defined in Amazon Web Services SSO.
     *
     * As part of a successful `CreateAccountAssignment` call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the SSO-created IAM role. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call ` <a>ProvisionPermissionSet</a> ` to make these updates.
     */
    override suspend fun createAccountAssignment(input: CreateAccountAssignmentRequest): CreateAccountAssignmentResponse {
        val op = SdkHttpOperation.build<CreateAccountAssignmentRequest, CreateAccountAssignmentResponse> {
            serializer = CreateAccountAssignmentOperationSerializer()
            deserializer = CreateAccountAssignmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAccountAssignment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Enables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    override suspend fun createInstanceAccessControlAttributeConfiguration(input: CreateInstanceAccessControlAttributeConfigurationRequest): CreateInstanceAccessControlAttributeConfigurationResponse {
        val op = SdkHttpOperation.build<CreateInstanceAccessControlAttributeConfigurationRequest, CreateInstanceAccessControlAttributeConfigurationResponse> {
            serializer = CreateInstanceAccessControlAttributeConfigurationOperationSerializer()
            deserializer = CreateInstanceAccessControlAttributeConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInstanceAccessControlAttributeConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a permission set within a specified SSO instance.
     *
     * To grant users and groups access to Amazon Web Services account resources, use ` <a>CreateAccountAssignment</a> `.
     */
    override suspend fun createPermissionSet(input: CreatePermissionSetRequest): CreatePermissionSetResponse {
        val op = SdkHttpOperation.build<CreatePermissionSetRequest, CreatePermissionSetResponse> {
            serializer = CreatePermissionSetOperationSerializer()
            deserializer = CreatePermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreatePermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a principal's access from a specified Amazon Web Services account using a specified permission set.
     */
    override suspend fun deleteAccountAssignment(input: DeleteAccountAssignmentRequest): DeleteAccountAssignmentResponse {
        val op = SdkHttpOperation.build<DeleteAccountAssignmentRequest, DeleteAccountAssignmentResponse> {
            serializer = DeleteAccountAssignmentOperationSerializer()
            deserializer = DeleteAccountAssignmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccountAssignment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the inline policy from a specified permission set.
     */
    override suspend fun deleteInlinePolicyFromPermissionSet(input: DeleteInlinePolicyFromPermissionSetRequest): DeleteInlinePolicyFromPermissionSetResponse {
        val op = SdkHttpOperation.build<DeleteInlinePolicyFromPermissionSetRequest, DeleteInlinePolicyFromPermissionSetResponse> {
            serializer = DeleteInlinePolicyFromPermissionSetOperationSerializer()
            deserializer = DeleteInlinePolicyFromPermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInlinePolicyFromPermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disables the attributes-based access control (ABAC) feature for the specified Amazon Web Services SSO instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    override suspend fun deleteInstanceAccessControlAttributeConfiguration(input: DeleteInstanceAccessControlAttributeConfigurationRequest): DeleteInstanceAccessControlAttributeConfigurationResponse {
        val op = SdkHttpOperation.build<DeleteInstanceAccessControlAttributeConfigurationRequest, DeleteInstanceAccessControlAttributeConfigurationResponse> {
            serializer = DeleteInstanceAccessControlAttributeConfigurationOperationSerializer()
            deserializer = DeleteInstanceAccessControlAttributeConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInstanceAccessControlAttributeConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes the specified permission set.
     */
    override suspend fun deletePermissionSet(input: DeletePermissionSetRequest): DeletePermissionSetResponse {
        val op = SdkHttpOperation.build<DeletePermissionSetRequest, DeletePermissionSetResponse> {
            serializer = DeletePermissionSetOperationSerializer()
            deserializer = DeletePermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeletePermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of the assignment creation request.
     */
    override suspend fun describeAccountAssignmentCreationStatus(input: DescribeAccountAssignmentCreationStatusRequest): DescribeAccountAssignmentCreationStatusResponse {
        val op = SdkHttpOperation.build<DescribeAccountAssignmentCreationStatusRequest, DescribeAccountAssignmentCreationStatusResponse> {
            serializer = DescribeAccountAssignmentCreationStatusOperationSerializer()
            deserializer = DescribeAccountAssignmentCreationStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountAssignmentCreationStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status of the assignment deletion request.
     */
    override suspend fun describeAccountAssignmentDeletionStatus(input: DescribeAccountAssignmentDeletionStatusRequest): DescribeAccountAssignmentDeletionStatusResponse {
        val op = SdkHttpOperation.build<DescribeAccountAssignmentDeletionStatusRequest, DescribeAccountAssignmentDeletionStatusResponse> {
            serializer = DescribeAccountAssignmentDeletionStatusOperationSerializer()
            deserializer = DescribeAccountAssignmentDeletionStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccountAssignmentDeletionStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the list of Amazon Web Services SSO identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified Amazon Web Services SSO instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    override suspend fun describeInstanceAccessControlAttributeConfiguration(input: DescribeInstanceAccessControlAttributeConfigurationRequest): DescribeInstanceAccessControlAttributeConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeInstanceAccessControlAttributeConfigurationRequest, DescribeInstanceAccessControlAttributeConfigurationResponse> {
            serializer = DescribeInstanceAccessControlAttributeConfigurationOperationSerializer()
            deserializer = DescribeInstanceAccessControlAttributeConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeInstanceAccessControlAttributeConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Gets the details of the permission set.
     */
    override suspend fun describePermissionSet(input: DescribePermissionSetRequest): DescribePermissionSetResponse {
        val op = SdkHttpOperation.build<DescribePermissionSetRequest, DescribePermissionSetResponse> {
            serializer = DescribePermissionSetOperationSerializer()
            deserializer = DescribePermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Describes the status for the given permission set provisioning request.
     */
    override suspend fun describePermissionSetProvisioningStatus(input: DescribePermissionSetProvisioningStatusRequest): DescribePermissionSetProvisioningStatusResponse {
        val op = SdkHttpOperation.build<DescribePermissionSetProvisioningStatusRequest, DescribePermissionSetProvisioningStatusResponse> {
            serializer = DescribePermissionSetProvisioningStatusOperationSerializer()
            deserializer = DescribePermissionSetProvisioningStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePermissionSetProvisioningStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Detaches the attached IAM managed policy ARN from the specified permission set.
     */
    override suspend fun detachManagedPolicyFromPermissionSet(input: DetachManagedPolicyFromPermissionSetRequest): DetachManagedPolicyFromPermissionSetResponse {
        val op = SdkHttpOperation.build<DetachManagedPolicyFromPermissionSetRequest, DetachManagedPolicyFromPermissionSetResponse> {
            serializer = DetachManagedPolicyFromPermissionSetOperationSerializer()
            deserializer = DetachManagedPolicyFromPermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DetachManagedPolicyFromPermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Obtains the inline policy assigned to the permission set.
     */
    override suspend fun getInlinePolicyForPermissionSet(input: GetInlinePolicyForPermissionSetRequest): GetInlinePolicyForPermissionSetResponse {
        val op = SdkHttpOperation.build<GetInlinePolicyForPermissionSetRequest, GetInlinePolicyForPermissionSetResponse> {
            serializer = GetInlinePolicyForPermissionSetOperationSerializer()
            deserializer = GetInlinePolicyForPermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInlinePolicyForPermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the status of the Amazon Web Services account assignment creation requests for a specified SSO instance.
     */
    override suspend fun listAccountAssignmentCreationStatus(input: ListAccountAssignmentCreationStatusRequest): ListAccountAssignmentCreationStatusResponse {
        val op = SdkHttpOperation.build<ListAccountAssignmentCreationStatusRequest, ListAccountAssignmentCreationStatusResponse> {
            serializer = ListAccountAssignmentCreationStatusOperationSerializer()
            deserializer = ListAccountAssignmentCreationStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccountAssignmentCreationStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the status of the Amazon Web Services account assignment deletion requests for a specified SSO instance.
     */
    override suspend fun listAccountAssignmentDeletionStatus(input: ListAccountAssignmentDeletionStatusRequest): ListAccountAssignmentDeletionStatusResponse {
        val op = SdkHttpOperation.build<ListAccountAssignmentDeletionStatusRequest, ListAccountAssignmentDeletionStatusResponse> {
            serializer = ListAccountAssignmentDeletionStatusOperationSerializer()
            deserializer = ListAccountAssignmentDeletionStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccountAssignmentDeletionStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the assignee of the specified Amazon Web Services account with the specified permission set.
     */
    override suspend fun listAccountAssignments(input: ListAccountAssignmentsRequest): ListAccountAssignmentsResponse {
        val op = SdkHttpOperation.build<ListAccountAssignmentsRequest, ListAccountAssignmentsResponse> {
            serializer = ListAccountAssignmentsOperationSerializer()
            deserializer = ListAccountAssignmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccountAssignments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the Amazon Web Services accounts where the specified permission set is provisioned.
     */
    override suspend fun listAccountsForProvisionedPermissionSet(input: ListAccountsForProvisionedPermissionSetRequest): ListAccountsForProvisionedPermissionSetResponse {
        val op = SdkHttpOperation.build<ListAccountsForProvisionedPermissionSetRequest, ListAccountsForProvisionedPermissionSetResponse> {
            serializer = ListAccountsForProvisionedPermissionSetOperationSerializer()
            deserializer = ListAccountsForProvisionedPermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccountsForProvisionedPermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the SSO instances that the caller has access to.
     */
    override suspend fun listInstances(input: ListInstancesRequest): ListInstancesResponse {
        val op = SdkHttpOperation.build<ListInstancesRequest, ListInstancesResponse> {
            serializer = ListInstancesOperationSerializer()
            deserializer = ListInstancesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInstances"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the IAM managed policy that is attached to a specified permission set.
     */
    override suspend fun listManagedPoliciesInPermissionSet(input: ListManagedPoliciesInPermissionSetRequest): ListManagedPoliciesInPermissionSetResponse {
        val op = SdkHttpOperation.build<ListManagedPoliciesInPermissionSetRequest, ListManagedPoliciesInPermissionSetResponse> {
            serializer = ListManagedPoliciesInPermissionSetOperationSerializer()
            deserializer = ListManagedPoliciesInPermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListManagedPoliciesInPermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the status of the permission set provisioning requests for a specified SSO instance.
     */
    override suspend fun listPermissionSetProvisioningStatus(input: ListPermissionSetProvisioningStatusRequest): ListPermissionSetProvisioningStatusResponse {
        val op = SdkHttpOperation.build<ListPermissionSetProvisioningStatusRequest, ListPermissionSetProvisioningStatusResponse> {
            serializer = ListPermissionSetProvisioningStatusOperationSerializer()
            deserializer = ListPermissionSetProvisioningStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPermissionSetProvisioningStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the PermissionSets in an SSO instance.
     */
    override suspend fun listPermissionSets(input: ListPermissionSetsRequest): ListPermissionSetsResponse {
        val op = SdkHttpOperation.build<ListPermissionSetsRequest, ListPermissionSetsResponse> {
            serializer = ListPermissionSetsOperationSerializer()
            deserializer = ListPermissionSetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPermissionSets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the permission sets that are provisioned to a specified Amazon Web Services account.
     */
    override suspend fun listPermissionSetsProvisionedToAccount(input: ListPermissionSetsProvisionedToAccountRequest): ListPermissionSetsProvisionedToAccountResponse {
        val op = SdkHttpOperation.build<ListPermissionSetsProvisionedToAccountRequest, ListPermissionSetsProvisionedToAccountResponse> {
            serializer = ListPermissionSetsProvisionedToAccountOperationSerializer()
            deserializer = ListPermissionSetsProvisionedToAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPermissionSetsProvisionedToAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags that are attached to a specified resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * The process by which a specified permission set is provisioned to the specified target.
     */
    override suspend fun provisionPermissionSet(input: ProvisionPermissionSetRequest): ProvisionPermissionSetResponse {
        val op = SdkHttpOperation.build<ProvisionPermissionSetRequest, ProvisionPermissionSetResponse> {
            serializer = ProvisionPermissionSetOperationSerializer()
            deserializer = ProvisionPermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ProvisionPermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Attaches an IAM inline policy to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this action to apply the corresponding IAM policy updates to all assigned accounts.
     */
    override suspend fun putInlinePolicyToPermissionSet(input: PutInlinePolicyToPermissionSetRequest): PutInlinePolicyToPermissionSetResponse {
        val op = SdkHttpOperation.build<PutInlinePolicyToPermissionSetRequest, PutInlinePolicyToPermissionSetResponse> {
            serializer = PutInlinePolicyToPermissionSetOperationSerializer()
            deserializer = PutInlinePolicyToPermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutInlinePolicyToPermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Associates a set of tags with a specified resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Disassociates a set of tags from a specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the Amazon Web Services SSO identity store attributes that you can use with the Amazon Web Services SSO instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the Amazon Web Services SSO identity store. If a SAML assertion passes any of these attributes, Amazon Web Services SSO replaces the attribute value with the value from the Amazon Web Services SSO identity store. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *Amazon Web Services SSO User Guide*.
     */
    override suspend fun updateInstanceAccessControlAttributeConfiguration(input: UpdateInstanceAccessControlAttributeConfigurationRequest): UpdateInstanceAccessControlAttributeConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateInstanceAccessControlAttributeConfigurationRequest, UpdateInstanceAccessControlAttributeConfigurationResponse> {
            serializer = UpdateInstanceAccessControlAttributeConfigurationOperationSerializer()
            deserializer = UpdateInstanceAccessControlAttributeConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateInstanceAccessControlAttributeConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing permission set.
     */
    override suspend fun updatePermissionSet(input: UpdatePermissionSetRequest): UpdatePermissionSetResponse {
        val op = SdkHttpOperation.build<UpdatePermissionSetRequest, UpdatePermissionSetResponse> {
            serializer = UpdatePermissionSetOperationSerializer()
            deserializer = UpdatePermissionSetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdatePermissionSet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SWBExternalService", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "sso"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "sso")
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
