// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssoadmin.model.PermissionSetProvisioningStatus
import aws.sdk.kotlin.services.ssoadmin.model.ProvisionPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.SsoAdminException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ProvisionPermissionSetOperationDeserializer: HttpDeserialize<ProvisionPermissionSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ProvisionPermissionSetResponse {
        if (!response.status.isSuccess()) {
            throwProvisionPermissionSetError(context, response)
        }
        val builder = ProvisionPermissionSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeProvisionPermissionSetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwProvisionPermissionSetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsoAdminException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsoAdminException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeProvisionPermissionSetOperationBody(builder: ProvisionPermissionSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PERMISSIONSETPROVISIONINGSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("PermissionSetProvisioningStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PERMISSIONSETPROVISIONINGSTATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PERMISSIONSETPROVISIONINGSTATUS_DESCRIPTOR.index -> builder.permissionSetProvisioningStatus = deserializePermissionSetProvisioningStatusDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
