// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ssoadmin.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.ssoadmin.endpoints.EndpointProvider
import aws.sdk.kotlin.services.ssoadmin.model.*
import aws.sdk.kotlin.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.CreateAccountAssignmentRequest
import aws.sdk.kotlin.services.ssoadmin.model.CreateAccountAssignmentResponse
import aws.sdk.kotlin.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest
import aws.sdk.kotlin.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse
import aws.sdk.kotlin.services.ssoadmin.model.CreatePermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.CreatePermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.DeleteAccountAssignmentRequest
import aws.sdk.kotlin.services.ssoadmin.model.DeleteAccountAssignmentResponse
import aws.sdk.kotlin.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest
import aws.sdk.kotlin.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse
import aws.sdk.kotlin.services.ssoadmin.model.DeletePermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.DeletePermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest
import aws.sdk.kotlin.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse
import aws.sdk.kotlin.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.DescribePermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.DescribePermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentsRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentsResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListInstancesRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListInstancesResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetsRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetsResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ssoadmin.model.ProvisionPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.ProvisionPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.PutInlinePolicyToPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.TagResourceRequest
import aws.sdk.kotlin.services.ssoadmin.model.TagResourceResponse
import aws.sdk.kotlin.services.ssoadmin.model.UntagResourceRequest
import aws.sdk.kotlin.services.ssoadmin.model.UntagResourceResponse
import aws.sdk.kotlin.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest
import aws.sdk.kotlin.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse
import aws.sdk.kotlin.services.ssoadmin.model.UpdatePermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.UpdatePermissionSetResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * AWS IAM Identity Center (successor to AWS Single Sign-On) helps you securely create, or connect, your workforce identities and manage their access centrally across AWS accounts and applications. IAM Identity Center is the recommended approach for workforce authentication and authorization in AWS, for organizations of any size and type.
 *
 * Although AWS Single Sign-On was renamed, the `sso` and `identitystore` API namespaces will continue to retain their original name for backward compatibility purposes. For more information, see [IAM Identity Center rename](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html#renamed).
 *
 * This reference guide provides information on single sign-on operations which could be used for access management of AWS accounts. For information about IAM Identity Center features, see the [IAM Identity Center User Guide](https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html).
 *
 * Many operations in the IAM Identity Center APIs rely on identifiers for users and groups, known as principals. For more information about how to work with principals and principal IDs in IAM Identity Center, see the [Identity Store API Reference](https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/welcome.html).
 *
 * AWS provides SDKs that consist of libraries and sample code for various programming languages and platforms (Java, Ruby, .Net, iOS, Android, and more). The SDKs provide a convenient way to create programmatic access to IAM Identity Center and other AWS services. For more information about the AWS SDKs, including how to download and install them, see [Tools for Amazon Web Services](http://aws.amazon.com/tools/).
 */
public interface SsoAdminClient : SdkClient {

    override val serviceName: String
        get() = "SSO Admin"
    /**
     * SsoAdminClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): SsoAdminClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSsoAdminClient(config)
        }

        public operator fun invoke(config: Config): SsoAdminClient = DefaultSsoAdminClient(config)

        /**
         * Construct a [SsoAdminClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SsoAdminClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultSsoAdminClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "SSO Admin")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Attaches the specified customer managed policy to the specified PermissionSet.
     */
    public suspend fun attachCustomerManagedPolicyReferenceToPermissionSet(input: AttachCustomerManagedPolicyReferenceToPermissionSetRequest): AttachCustomerManagedPolicyReferenceToPermissionSetResponse

    /**
     * Attaches an AWS managed policy ARN to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this operation. Calling `ProvisionPermissionSet` applies the corresponding IAM policy updates to all assigned accounts.
     */
    public suspend fun attachManagedPolicyToPermissionSet(input: AttachManagedPolicyToPermissionSetRequest): AttachManagedPolicyToPermissionSetResponse

    /**
     * Assigns access to a principal for a specified AWS account using a specified permission set.
     *
     * The term *principal* here refers to a user or group that is defined in IAM Identity Center.
     *
     * As part of a successful `CreateAccountAssignment` call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call ` <a>ProvisionPermissionSet</a> ` to make these updates.
     *
     *  After a successful response, call `DescribeAccountAssignmentCreationStatus` to describe the status of an assignment creation request.
     */
    public suspend fun createAccountAssignment(input: CreateAccountAssignmentRequest): CreateAccountAssignmentResponse

    /**
     * Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
     *
     * After a successful response, call `DescribeInstanceAccessControlAttributeConfiguration` to validate that `InstanceAccessControlAttributeConfiguration` was created.
     */
    public suspend fun createInstanceAccessControlAttributeConfiguration(input: CreateInstanceAccessControlAttributeConfigurationRequest): CreateInstanceAccessControlAttributeConfigurationResponse

    /**
     * Creates a permission set within a specified IAM Identity Center instance.
     *
     * To grant users and groups access to AWS account resources, use ` <a>CreateAccountAssignment</a> `.
     */
    public suspend fun createPermissionSet(input: CreatePermissionSetRequest): CreatePermissionSetResponse

    /**
     * Deletes a principal's access from a specified AWS account using a specified permission set.
     *
     * After a successful response, call `DescribeAccountAssignmentCreationStatus` to describe the status of an assignment deletion request.
     */
    public suspend fun deleteAccountAssignment(input: DeleteAccountAssignmentRequest): DeleteAccountAssignmentResponse

    /**
     * Deletes the inline policy from a specified permission set.
     */
    public suspend fun deleteInlinePolicyFromPermissionSet(input: DeleteInlinePolicyFromPermissionSetRequest): DeleteInlinePolicyFromPermissionSetResponse

    /**
     * Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
     */
    public suspend fun deleteInstanceAccessControlAttributeConfiguration(input: DeleteInstanceAccessControlAttributeConfigurationRequest): DeleteInstanceAccessControlAttributeConfigurationResponse

    /**
     * Deletes the specified permission set.
     */
    public suspend fun deletePermissionSet(input: DeletePermissionSetRequest): DeletePermissionSetResponse

    /**
     * Deletes the permissions boundary from a specified PermissionSet.
     */
    public suspend fun deletePermissionsBoundaryFromPermissionSet(input: DeletePermissionsBoundaryFromPermissionSetRequest): DeletePermissionsBoundaryFromPermissionSetResponse

    /**
     * Describes the status of the assignment creation request.
     */
    public suspend fun describeAccountAssignmentCreationStatus(input: DescribeAccountAssignmentCreationStatusRequest): DescribeAccountAssignmentCreationStatusResponse

    /**
     * Describes the status of the assignment deletion request.
     */
    public suspend fun describeAccountAssignmentDeletionStatus(input: DescribeAccountAssignmentDeletionStatusRequest): DescribeAccountAssignmentDeletionStatusResponse

    /**
     * Returns the list of IAM Identity Center identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
     */
    public suspend fun describeInstanceAccessControlAttributeConfiguration(input: DescribeInstanceAccessControlAttributeConfigurationRequest): DescribeInstanceAccessControlAttributeConfigurationResponse

    /**
     * Gets the details of the permission set.
     */
    public suspend fun describePermissionSet(input: DescribePermissionSetRequest): DescribePermissionSetResponse

    /**
     * Describes the status for the given permission set provisioning request.
     */
    public suspend fun describePermissionSetProvisioningStatus(input: DescribePermissionSetProvisioningStatusRequest): DescribePermissionSetProvisioningStatusResponse

    /**
     * Detaches the specified customer managed policy from the specified PermissionSet.
     */
    public suspend fun detachCustomerManagedPolicyReferenceFromPermissionSet(input: DetachCustomerManagedPolicyReferenceFromPermissionSetRequest): DetachCustomerManagedPolicyReferenceFromPermissionSetResponse

    /**
     * Detaches the attached AWS managed policy ARN from the specified permission set.
     */
    public suspend fun detachManagedPolicyFromPermissionSet(input: DetachManagedPolicyFromPermissionSetRequest): DetachManagedPolicyFromPermissionSetResponse

    /**
     * Obtains the inline policy assigned to the permission set.
     */
    public suspend fun getInlinePolicyForPermissionSet(input: GetInlinePolicyForPermissionSetRequest): GetInlinePolicyForPermissionSetResponse

    /**
     * Obtains the permissions boundary for a specified PermissionSet.
     */
    public suspend fun getPermissionsBoundaryForPermissionSet(input: GetPermissionsBoundaryForPermissionSetRequest): GetPermissionsBoundaryForPermissionSetResponse

    /**
     * Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
     */
    public suspend fun listAccountAssignmentCreationStatus(input: ListAccountAssignmentCreationStatusRequest): ListAccountAssignmentCreationStatusResponse

    /**
     * Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
     */
    public suspend fun listAccountAssignmentDeletionStatus(input: ListAccountAssignmentDeletionStatusRequest): ListAccountAssignmentDeletionStatusResponse

    /**
     * Lists the assignee of the specified AWS account with the specified permission set.
     */
    public suspend fun listAccountAssignments(input: ListAccountAssignmentsRequest): ListAccountAssignmentsResponse

    /**
     * Lists all the AWS accounts where the specified permission set is provisioned.
     */
    public suspend fun listAccountsForProvisionedPermissionSet(input: ListAccountsForProvisionedPermissionSetRequest): ListAccountsForProvisionedPermissionSetResponse

    /**
     * Lists all customer managed policies attached to a specified PermissionSet.
     */
    public suspend fun listCustomerManagedPolicyReferencesInPermissionSet(input: ListCustomerManagedPolicyReferencesInPermissionSetRequest): ListCustomerManagedPolicyReferencesInPermissionSetResponse

    /**
     * Lists the IAM Identity Center instances that the caller has access to.
     */
    public suspend fun listInstances(input: ListInstancesRequest = ListInstancesRequest {}): ListInstancesResponse

    /**
     * Lists the AWS managed policy that is attached to a specified permission set.
     */
    public suspend fun listManagedPoliciesInPermissionSet(input: ListManagedPoliciesInPermissionSetRequest): ListManagedPoliciesInPermissionSetResponse

    /**
     * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
     */
    public suspend fun listPermissionSetProvisioningStatus(input: ListPermissionSetProvisioningStatusRequest): ListPermissionSetProvisioningStatusResponse

    /**
     * Lists the PermissionSets in an IAM Identity Center instance.
     */
    public suspend fun listPermissionSets(input: ListPermissionSetsRequest): ListPermissionSetsResponse

    /**
     * Lists all the permission sets that are provisioned to a specified AWS account.
     */
    public suspend fun listPermissionSetsProvisionedToAccount(input: ListPermissionSetsProvisionedToAccountRequest): ListPermissionSetsProvisionedToAccountResponse

    /**
     * Lists the tags that are attached to a specified resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * The process by which a specified permission set is provisioned to the specified target.
     */
    public suspend fun provisionPermissionSet(input: ProvisionPermissionSetRequest): ProvisionPermissionSetResponse

    /**
     * Attaches an inline policy to a permission set.
     *
     * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this action to apply the corresponding IAM policy updates to all assigned accounts.
     */
    public suspend fun putInlinePolicyToPermissionSet(input: PutInlinePolicyToPermissionSetRequest): PutInlinePolicyToPermissionSetResponse

    /**
     * Attaches an AWS managed or customer managed policy to the specified PermissionSet as a permissions boundary.
     */
    public suspend fun putPermissionsBoundaryToPermissionSet(input: PutPermissionsBoundaryToPermissionSetRequest): PutPermissionsBoundaryToPermissionSetResponse

    /**
     * Associates a set of tags with a specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Disassociates a set of tags from a specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
     */
    public suspend fun updateInstanceAccessControlAttributeConfiguration(input: UpdateInstanceAccessControlAttributeConfigurationRequest): UpdateInstanceAccessControlAttributeConfigurationResponse

    /**
     * Updates an existing permission set.
     */
    public suspend fun updatePermissionSet(input: UpdatePermissionSetRequest): UpdatePermissionSetResponse
}

/**
 * Attaches the specified customer managed policy to the specified PermissionSet.
 */
public suspend inline fun SsoAdminClient.attachCustomerManagedPolicyReferenceToPermissionSet(crossinline block: AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder.() -> Unit): AttachCustomerManagedPolicyReferenceToPermissionSetResponse = attachCustomerManagedPolicyReferenceToPermissionSet(AttachCustomerManagedPolicyReferenceToPermissionSetRequest.Builder().apply(block).build())

/**
 * Attaches an AWS managed policy ARN to a permission set.
 *
 * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this operation. Calling `ProvisionPermissionSet` applies the corresponding IAM policy updates to all assigned accounts.
 */
public suspend inline fun SsoAdminClient.attachManagedPolicyToPermissionSet(crossinline block: AttachManagedPolicyToPermissionSetRequest.Builder.() -> Unit): AttachManagedPolicyToPermissionSetResponse = attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest.Builder().apply(block).build())

/**
 * Assigns access to a principal for a specified AWS account using a specified permission set.
 *
 * The term *principal* here refers to a user or group that is defined in IAM Identity Center.
 *
 * As part of a successful `CreateAccountAssignment` call, the specified permission set will automatically be provisioned to the account in the form of an IAM policy. That policy is attached to the IAM role created in IAM Identity Center. If the permission set is subsequently updated, the corresponding IAM policies attached to roles in your accounts will not be updated automatically. In this case, you must call ` <a>ProvisionPermissionSet</a> ` to make these updates.
 *
 *  After a successful response, call `DescribeAccountAssignmentCreationStatus` to describe the status of an assignment creation request.
 */
public suspend inline fun SsoAdminClient.createAccountAssignment(crossinline block: CreateAccountAssignmentRequest.Builder.() -> Unit): CreateAccountAssignmentResponse = createAccountAssignment(CreateAccountAssignmentRequest.Builder().apply(block).build())

/**
 * Enables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance. You can also specify new attributes to add to your ABAC configuration during the enabling process. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
 *
 * After a successful response, call `DescribeInstanceAccessControlAttributeConfiguration` to validate that `InstanceAccessControlAttributeConfiguration` was created.
 */
public suspend inline fun SsoAdminClient.createInstanceAccessControlAttributeConfiguration(crossinline block: CreateInstanceAccessControlAttributeConfigurationRequest.Builder.() -> Unit): CreateInstanceAccessControlAttributeConfigurationResponse = createInstanceAccessControlAttributeConfiguration(CreateInstanceAccessControlAttributeConfigurationRequest.Builder().apply(block).build())

/**
 * Creates a permission set within a specified IAM Identity Center instance.
 *
 * To grant users and groups access to AWS account resources, use ` <a>CreateAccountAssignment</a> `.
 */
public suspend inline fun SsoAdminClient.createPermissionSet(crossinline block: CreatePermissionSetRequest.Builder.() -> Unit): CreatePermissionSetResponse = createPermissionSet(CreatePermissionSetRequest.Builder().apply(block).build())

/**
 * Deletes a principal's access from a specified AWS account using a specified permission set.
 *
 * After a successful response, call `DescribeAccountAssignmentCreationStatus` to describe the status of an assignment deletion request.
 */
public suspend inline fun SsoAdminClient.deleteAccountAssignment(crossinline block: DeleteAccountAssignmentRequest.Builder.() -> Unit): DeleteAccountAssignmentResponse = deleteAccountAssignment(DeleteAccountAssignmentRequest.Builder().apply(block).build())

/**
 * Deletes the inline policy from a specified permission set.
 */
public suspend inline fun SsoAdminClient.deleteInlinePolicyFromPermissionSet(crossinline block: DeleteInlinePolicyFromPermissionSetRequest.Builder.() -> Unit): DeleteInlinePolicyFromPermissionSetResponse = deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest.Builder().apply(block).build())

/**
 * Disables the attributes-based access control (ABAC) feature for the specified IAM Identity Center instance and deletes all of the attribute mappings that have been configured. Once deleted, any attributes that are received from an identity source and any custom attributes you have previously configured will not be passed. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
 */
public suspend inline fun SsoAdminClient.deleteInstanceAccessControlAttributeConfiguration(crossinline block: DeleteInstanceAccessControlAttributeConfigurationRequest.Builder.() -> Unit): DeleteInstanceAccessControlAttributeConfigurationResponse = deleteInstanceAccessControlAttributeConfiguration(DeleteInstanceAccessControlAttributeConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes the specified permission set.
 */
public suspend inline fun SsoAdminClient.deletePermissionSet(crossinline block: DeletePermissionSetRequest.Builder.() -> Unit): DeletePermissionSetResponse = deletePermissionSet(DeletePermissionSetRequest.Builder().apply(block).build())

/**
 * Deletes the permissions boundary from a specified PermissionSet.
 */
public suspend inline fun SsoAdminClient.deletePermissionsBoundaryFromPermissionSet(crossinline block: DeletePermissionsBoundaryFromPermissionSetRequest.Builder.() -> Unit): DeletePermissionsBoundaryFromPermissionSetResponse = deletePermissionsBoundaryFromPermissionSet(DeletePermissionsBoundaryFromPermissionSetRequest.Builder().apply(block).build())

/**
 * Describes the status of the assignment creation request.
 */
public suspend inline fun SsoAdminClient.describeAccountAssignmentCreationStatus(crossinline block: DescribeAccountAssignmentCreationStatusRequest.Builder.() -> Unit): DescribeAccountAssignmentCreationStatusResponse = describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest.Builder().apply(block).build())

/**
 * Describes the status of the assignment deletion request.
 */
public suspend inline fun SsoAdminClient.describeAccountAssignmentDeletionStatus(crossinline block: DescribeAccountAssignmentDeletionStatusRequest.Builder.() -> Unit): DescribeAccountAssignmentDeletionStatusResponse = describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest.Builder().apply(block).build())

/**
 * Returns the list of IAM Identity Center identity store attributes that have been configured to work with attributes-based access control (ABAC) for the specified IAM Identity Center instance. This will not return attributes configured and sent by an external identity provider. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
 */
public suspend inline fun SsoAdminClient.describeInstanceAccessControlAttributeConfiguration(crossinline block: DescribeInstanceAccessControlAttributeConfigurationRequest.Builder.() -> Unit): DescribeInstanceAccessControlAttributeConfigurationResponse = describeInstanceAccessControlAttributeConfiguration(DescribeInstanceAccessControlAttributeConfigurationRequest.Builder().apply(block).build())

/**
 * Gets the details of the permission set.
 */
public suspend inline fun SsoAdminClient.describePermissionSet(crossinline block: DescribePermissionSetRequest.Builder.() -> Unit): DescribePermissionSetResponse = describePermissionSet(DescribePermissionSetRequest.Builder().apply(block).build())

/**
 * Describes the status for the given permission set provisioning request.
 */
public suspend inline fun SsoAdminClient.describePermissionSetProvisioningStatus(crossinline block: DescribePermissionSetProvisioningStatusRequest.Builder.() -> Unit): DescribePermissionSetProvisioningStatusResponse = describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest.Builder().apply(block).build())

/**
 * Detaches the specified customer managed policy from the specified PermissionSet.
 */
public suspend inline fun SsoAdminClient.detachCustomerManagedPolicyReferenceFromPermissionSet(crossinline block: DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.Builder.() -> Unit): DetachCustomerManagedPolicyReferenceFromPermissionSetResponse = detachCustomerManagedPolicyReferenceFromPermissionSet(DetachCustomerManagedPolicyReferenceFromPermissionSetRequest.Builder().apply(block).build())

/**
 * Detaches the attached AWS managed policy ARN from the specified permission set.
 */
public suspend inline fun SsoAdminClient.detachManagedPolicyFromPermissionSet(crossinline block: DetachManagedPolicyFromPermissionSetRequest.Builder.() -> Unit): DetachManagedPolicyFromPermissionSetResponse = detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest.Builder().apply(block).build())

/**
 * Obtains the inline policy assigned to the permission set.
 */
public suspend inline fun SsoAdminClient.getInlinePolicyForPermissionSet(crossinline block: GetInlinePolicyForPermissionSetRequest.Builder.() -> Unit): GetInlinePolicyForPermissionSetResponse = getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest.Builder().apply(block).build())

/**
 * Obtains the permissions boundary for a specified PermissionSet.
 */
public suspend inline fun SsoAdminClient.getPermissionsBoundaryForPermissionSet(crossinline block: GetPermissionsBoundaryForPermissionSetRequest.Builder.() -> Unit): GetPermissionsBoundaryForPermissionSetResponse = getPermissionsBoundaryForPermissionSet(GetPermissionsBoundaryForPermissionSetRequest.Builder().apply(block).build())

/**
 * Lists the status of the AWS account assignment creation requests for a specified IAM Identity Center instance.
 */
public suspend inline fun SsoAdminClient.listAccountAssignmentCreationStatus(crossinline block: ListAccountAssignmentCreationStatusRequest.Builder.() -> Unit): ListAccountAssignmentCreationStatusResponse = listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest.Builder().apply(block).build())

/**
 * Lists the status of the AWS account assignment deletion requests for a specified IAM Identity Center instance.
 */
public suspend inline fun SsoAdminClient.listAccountAssignmentDeletionStatus(crossinline block: ListAccountAssignmentDeletionStatusRequest.Builder.() -> Unit): ListAccountAssignmentDeletionStatusResponse = listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest.Builder().apply(block).build())

/**
 * Lists the assignee of the specified AWS account with the specified permission set.
 */
public suspend inline fun SsoAdminClient.listAccountAssignments(crossinline block: ListAccountAssignmentsRequest.Builder.() -> Unit): ListAccountAssignmentsResponse = listAccountAssignments(ListAccountAssignmentsRequest.Builder().apply(block).build())

/**
 * Lists all the AWS accounts where the specified permission set is provisioned.
 */
public suspend inline fun SsoAdminClient.listAccountsForProvisionedPermissionSet(crossinline block: ListAccountsForProvisionedPermissionSetRequest.Builder.() -> Unit): ListAccountsForProvisionedPermissionSetResponse = listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest.Builder().apply(block).build())

/**
 * Lists all customer managed policies attached to a specified PermissionSet.
 */
public suspend inline fun SsoAdminClient.listCustomerManagedPolicyReferencesInPermissionSet(crossinline block: ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder.() -> Unit): ListCustomerManagedPolicyReferencesInPermissionSetResponse = listCustomerManagedPolicyReferencesInPermissionSet(ListCustomerManagedPolicyReferencesInPermissionSetRequest.Builder().apply(block).build())

/**
 * Lists the IAM Identity Center instances that the caller has access to.
 */
public suspend inline fun SsoAdminClient.listInstances(crossinline block: ListInstancesRequest.Builder.() -> Unit): ListInstancesResponse = listInstances(ListInstancesRequest.Builder().apply(block).build())

/**
 * Lists the AWS managed policy that is attached to a specified permission set.
 */
public suspend inline fun SsoAdminClient.listManagedPoliciesInPermissionSet(crossinline block: ListManagedPoliciesInPermissionSetRequest.Builder.() -> Unit): ListManagedPoliciesInPermissionSetResponse = listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest.Builder().apply(block).build())

/**
 * Lists the status of the permission set provisioning requests for a specified IAM Identity Center instance.
 */
public suspend inline fun SsoAdminClient.listPermissionSetProvisioningStatus(crossinline block: ListPermissionSetProvisioningStatusRequest.Builder.() -> Unit): ListPermissionSetProvisioningStatusResponse = listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest.Builder().apply(block).build())

/**
 * Lists the PermissionSets in an IAM Identity Center instance.
 */
public suspend inline fun SsoAdminClient.listPermissionSets(crossinline block: ListPermissionSetsRequest.Builder.() -> Unit): ListPermissionSetsResponse = listPermissionSets(ListPermissionSetsRequest.Builder().apply(block).build())

/**
 * Lists all the permission sets that are provisioned to a specified AWS account.
 */
public suspend inline fun SsoAdminClient.listPermissionSetsProvisionedToAccount(crossinline block: ListPermissionSetsProvisionedToAccountRequest.Builder.() -> Unit): ListPermissionSetsProvisionedToAccountResponse = listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest.Builder().apply(block).build())

/**
 * Lists the tags that are attached to a specified resource.
 */
public suspend inline fun SsoAdminClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * The process by which a specified permission set is provisioned to the specified target.
 */
public suspend inline fun SsoAdminClient.provisionPermissionSet(crossinline block: ProvisionPermissionSetRequest.Builder.() -> Unit): ProvisionPermissionSetResponse = provisionPermissionSet(ProvisionPermissionSetRequest.Builder().apply(block).build())

/**
 * Attaches an inline policy to a permission set.
 *
 * If the permission set is already referenced by one or more account assignments, you will need to call ` <a>ProvisionPermissionSet</a> ` after this action to apply the corresponding IAM policy updates to all assigned accounts.
 */
public suspend inline fun SsoAdminClient.putInlinePolicyToPermissionSet(crossinline block: PutInlinePolicyToPermissionSetRequest.Builder.() -> Unit): PutInlinePolicyToPermissionSetResponse = putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest.Builder().apply(block).build())

/**
 * Attaches an AWS managed or customer managed policy to the specified PermissionSet as a permissions boundary.
 */
public suspend inline fun SsoAdminClient.putPermissionsBoundaryToPermissionSet(crossinline block: PutPermissionsBoundaryToPermissionSetRequest.Builder.() -> Unit): PutPermissionsBoundaryToPermissionSetResponse = putPermissionsBoundaryToPermissionSet(PutPermissionsBoundaryToPermissionSetRequest.Builder().apply(block).build())

/**
 * Associates a set of tags with a specified resource.
 */
public suspend inline fun SsoAdminClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Disassociates a set of tags from a specified resource.
 */
public suspend inline fun SsoAdminClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the IAM Identity Center identity store attributes that you can use with the IAM Identity Center instance for attributes-based access control (ABAC). When using an external identity provider as an identity source, you can pass attributes through the SAML assertion as an alternative to configuring attributes from the IAM Identity Center identity store. If a SAML assertion passes any of these attributes, IAM Identity Center replaces the attribute value with the value from the IAM Identity Center identity store. For more information about ABAC, see [Attribute-Based Access Control](/singlesignon/latest/userguide/abac.html) in the *IAM Identity Center User Guide*.
 */
public suspend inline fun SsoAdminClient.updateInstanceAccessControlAttributeConfiguration(crossinline block: UpdateInstanceAccessControlAttributeConfigurationRequest.Builder.() -> Unit): UpdateInstanceAccessControlAttributeConfigurationResponse = updateInstanceAccessControlAttributeConfiguration(UpdateInstanceAccessControlAttributeConfigurationRequest.Builder().apply(block).build())

/**
 * Updates an existing permission set.
 */
public suspend inline fun SsoAdminClient.updatePermissionSet(crossinline block: UpdatePermissionSetRequest.Builder.() -> Unit): UpdatePermissionSetResponse = updatePermissionSet(UpdatePermissionSetRequest.Builder().apply(block).build())
