// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that is used to provide the status of the provisioning operation for a specified permission set.
 */
public class PermissionSetProvisioningStatus private constructor(builder: Builder) {
    /**
     * The identifier of the AWS account from which to list the assignments.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The date that the permission set was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The message that contains an error or exception in case of an operation failure.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The ARN of the permission set that is being provisioned. For more information about ARNs, see [Amazon Resource Names (ARNs) and AWS Service Namespaces](/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
     */
    public val permissionSetArn: kotlin.String? = builder.permissionSetArn
    /**
     * The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.
     */
    public val requestId: kotlin.String? = builder.requestId
    /**
     * The status of the permission set provisioning process.
     */
    public val status: aws.sdk.kotlin.services.ssoadmin.model.StatusValues? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.PermissionSetProvisioningStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PermissionSetProvisioningStatus(")
        append("accountId=$accountId,")
        append("createdDate=$createdDate,")
        append("failureReason=$failureReason,")
        append("permissionSetArn=$permissionSetArn,")
        append("requestId=$requestId,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (createdDate?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (permissionSetArn?.hashCode() ?: 0)
        result = 31 * result + (requestId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PermissionSetProvisioningStatus

        if (accountId != other.accountId) return false
        if (createdDate != other.createdDate) return false
        if (failureReason != other.failureReason) return false
        if (permissionSetArn != other.permissionSetArn) return false
        if (requestId != other.requestId) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.PermissionSetProvisioningStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the AWS account from which to list the assignments.
         */
        public var accountId: kotlin.String? = null
        /**
         * The date that the permission set was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The message that contains an error or exception in case of an operation failure.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The ARN of the permission set that is being provisioned. For more information about ARNs, see [Amazon Resource Names (ARNs) and AWS Service Namespaces](/general/latest/gr/aws-arns-and-namespaces.html) in the *AWS General Reference*.
         */
        public var permissionSetArn: kotlin.String? = null
        /**
         * The identifier for tracking the request operation that is generated by the universally unique identifier (UUID) workflow.
         */
        public var requestId: kotlin.String? = null
        /**
         * The status of the permission set provisioning process.
         */
        public var status: aws.sdk.kotlin.services.ssoadmin.model.StatusValues? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.PermissionSetProvisioningStatus) : this() {
            this.accountId = x.accountId
            this.createdDate = x.createdDate
            this.failureReason = x.failureReason
            this.permissionSetArn = x.permissionSetArn
            this.requestId = x.requestId
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.PermissionSetProvisioningStatus = PermissionSetProvisioningStatus(this)
    }
}
