// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model



/**
 * Specifies the configuration of the AWS managed or customer managed policy that you want to set as a permissions boundary. Specify either `CustomerManagedPolicyReference` to use the name and path of a customer managed policy, or `ManagedPolicyArn` to use the ARN of an AWS managed policy. A permissions boundary represents the maximum permissions that any policy can grant your role. For more information, see [Permissions boundaries for IAM entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html) in the *IAM User Guide*.
 *
 * Policies used as permissions boundaries don't provide permissions. You must also attach an IAM policy to the role. To learn how the effective permissions for a role are evaluated, see [IAM JSON policy evaluation logic](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html) in the *IAM User Guide*.
 */
public class PermissionsBoundary private constructor(builder: Builder) {
    /**
     * Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each AWS account where you want to deploy your permission set.
     */
    public val customerManagedPolicyReference: aws.sdk.kotlin.services.ssoadmin.model.CustomerManagedPolicyReference? = builder.customerManagedPolicyReference
    /**
     * The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
     */
    public val managedPolicyArn: kotlin.String? = builder.managedPolicyArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.PermissionsBoundary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PermissionsBoundary(")
        append("customerManagedPolicyReference=$customerManagedPolicyReference,")
        append("managedPolicyArn=$managedPolicyArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customerManagedPolicyReference?.hashCode() ?: 0
        result = 31 * result + (managedPolicyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PermissionsBoundary

        if (customerManagedPolicyReference != other.customerManagedPolicyReference) return false
        if (managedPolicyArn != other.managedPolicyArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.PermissionsBoundary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the name and path of a customer managed policy. You must have an IAM policy that matches the name and path in each AWS account where you want to deploy your permission set.
         */
        public var customerManagedPolicyReference: aws.sdk.kotlin.services.ssoadmin.model.CustomerManagedPolicyReference? = null
        /**
         * The AWS managed policy ARN that you want to attach to a permission set as a permissions boundary.
         */
        public var managedPolicyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.PermissionsBoundary) : this() {
            this.customerManagedPolicyReference = x.customerManagedPolicyReference
            this.managedPolicyArn = x.managedPolicyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.PermissionsBoundary = PermissionsBoundary(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssoadmin.model.CustomerManagedPolicyReference] inside the given [block]
         */
        public fun customerManagedPolicyReference(block: aws.sdk.kotlin.services.ssoadmin.model.CustomerManagedPolicyReference.Builder.() -> kotlin.Unit) {
            this.customerManagedPolicyReference = aws.sdk.kotlin.services.ssoadmin.model.CustomerManagedPolicyReference.invoke(block)
        }
    }
}
