// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssoadmin.model.AttachedManagedPolicy
import aws.sdk.kotlin.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.SsoAdminException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListManagedPoliciesInPermissionSetOperationDeserializer: HttpDeserialize<ListManagedPoliciesInPermissionSetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListManagedPoliciesInPermissionSetResponse {
        if (!response.status.isSuccess()) {
            throwListManagedPoliciesInPermissionSetError(context, response)
        }
        val builder = ListManagedPoliciesInPermissionSetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListManagedPoliciesInPermissionSetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListManagedPoliciesInPermissionSetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsoAdminException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsoAdminException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListManagedPoliciesInPermissionSetOperationBody(builder: ListManagedPoliciesInPermissionSetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ATTACHEDMANAGEDPOLICIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AttachedManagedPolicies"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ATTACHEDMANAGEDPOLICIES_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ATTACHEDMANAGEDPOLICIES_DESCRIPTOR.index -> builder.attachedManagedPolicies =
                    deserializer.deserializeList(ATTACHEDMANAGEDPOLICIES_DESCRIPTOR) {
                        val col0 = mutableListOf<AttachedManagedPolicy>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAttachedManagedPolicyDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
