// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.model



/**
 * These are Amazon Web Services SSO identity store attributes that you can configure for use in
 * attributes-based access control (ABAC). You can create permissions policies that determine who
 * can access your Amazon Web Services resources based upon the configured attribute values. When you enable
 * ABAC and specify AccessControlAttributes, Amazon Web Services SSO passes the attribute values
 * of the authenticated user into IAM for use in policy evaluation.
 */
class AccessControlAttribute private constructor(builder: Builder) {
    /**
     * The name of the attribute associated with your identities in your identity source. This is
     * used to map a specified attribute in your identity source with an attribute in Amazon Web Services
     * SSO.
     */
    val key: kotlin.String? = builder.key
    /**
     * The value used for mapping a specified attribute to an identity source.
     */
    val value: aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttributeValue? = builder.value

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttribute = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessControlAttribute(")
        append("key=$key,")
        append("value=$value)")
    }

    override fun hashCode(): kotlin.Int {
        var result = key?.hashCode() ?: 0
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessControlAttribute

        if (key != other.key) return false
        if (value != other.value) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttribute = Builder(this).apply(block).build()

    class Builder {
        /**
         * The name of the attribute associated with your identities in your identity source. This is
         * used to map a specified attribute in your identity source with an attribute in Amazon Web Services
         * SSO.
         */
        var key: kotlin.String? = null
        /**
         * The value used for mapping a specified attribute to an identity source.
         */
        var value: aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttributeValue? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttribute) : this() {
            this.key = x.key
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttribute = AccessControlAttribute(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttributeValue] inside the given [block]
         */
        fun value(block: aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttributeValue.Builder.() -> kotlin.Unit) {
            this.value = aws.sdk.kotlin.services.ssoadmin.model.AccessControlAttributeValue.invoke(block)
        }
    }
}
