// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssoadmin.paginators

import aws.sdk.kotlin.services.ssoadmin.SsoAdminClient
import aws.sdk.kotlin.services.ssoadmin.model.AccountAssignment
import aws.sdk.kotlin.services.ssoadmin.model.AccountAssignmentOperationStatusMetadata
import aws.sdk.kotlin.services.ssoadmin.model.AttachedManagedPolicy
import aws.sdk.kotlin.services.ssoadmin.model.InstanceMetadata
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentsRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountAssignmentsResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListInstancesRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListInstancesResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetsRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListPermissionSetsResponse
import aws.sdk.kotlin.services.ssoadmin.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ssoadmin.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ssoadmin.model.PermissionSetProvisioningStatusMetadata
import aws.sdk.kotlin.services.ssoadmin.model.Tag
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAccountAssignmentCreationStatusResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListAccountAssignmentCreationStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAssignmentCreationStatusResponse]
 */
fun SsoAdminClient.listAccountAssignmentCreationStatusPaginated(initialRequest: ListAccountAssignmentCreationStatusRequest): Flow<ListAccountAssignmentCreationStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountAssignmentCreationStatusPaginated.listAccountAssignmentCreationStatus(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listAccountAssignmentCreationStatusPaginated]
 * to access the nested member [AccountAssignmentOperationStatusMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountAssignmentOperationStatusMetadata]
 */
@JvmName("listAccountAssignmentCreationStatusResponseAccountAssignmentOperationStatusMetadata")
fun Flow<ListAccountAssignmentCreationStatusResponse>.accountAssignmentsCreationStatus(): Flow<AccountAssignmentOperationStatusMetadata> =
    transform() { response ->
        response.accountAssignmentsCreationStatus?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccountAssignmentDeletionStatusResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListAccountAssignmentDeletionStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAssignmentDeletionStatusResponse]
 */
fun SsoAdminClient.listAccountAssignmentDeletionStatusPaginated(initialRequest: ListAccountAssignmentDeletionStatusRequest): Flow<ListAccountAssignmentDeletionStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountAssignmentDeletionStatusPaginated.listAccountAssignmentDeletionStatus(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listAccountAssignmentDeletionStatusPaginated]
 * to access the nested member [AccountAssignmentOperationStatusMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountAssignmentOperationStatusMetadata]
 */
@JvmName("listAccountAssignmentDeletionStatusResponseAccountAssignmentOperationStatusMetadata")
fun Flow<ListAccountAssignmentDeletionStatusResponse>.accountAssignmentsDeletionStatus(): Flow<AccountAssignmentOperationStatusMetadata> =
    transform() { response ->
        response.accountAssignmentsDeletionStatus?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccountAssignmentsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListAccountAssignmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountAssignmentsResponse]
 */
fun SsoAdminClient.listAccountAssignmentsPaginated(initialRequest: ListAccountAssignmentsRequest): Flow<ListAccountAssignmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountAssignmentsPaginated.listAccountAssignments(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listAccountAssignmentsPaginated]
 * to access the nested member [AccountAssignment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountAssignment]
 */
@JvmName("listAccountAssignmentsResponseAccountAssignment")
fun Flow<ListAccountAssignmentsResponse>.accountAssignments(): Flow<AccountAssignment> =
    transform() { response ->
        response.accountAssignments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAccountsForProvisionedPermissionSetResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListAccountsForProvisionedPermissionSetRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAccountsForProvisionedPermissionSetResponse]
 */
fun SsoAdminClient.listAccountsForProvisionedPermissionSetPaginated(initialRequest: ListAccountsForProvisionedPermissionSetRequest): Flow<ListAccountsForProvisionedPermissionSetResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAccountsForProvisionedPermissionSetPaginated.listAccountsForProvisionedPermissionSet(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listAccountsForProvisionedPermissionSetPaginated]
 * to access the nested member [AccountId]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AccountId]
 */
@JvmName("listAccountsForProvisionedPermissionSetResponseAccountId")
fun Flow<ListAccountsForProvisionedPermissionSetResponse>.accountIds(): Flow<String> =
    transform() { response ->
        response.accountIds?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListInstancesResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListInstancesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListInstancesResponse]
 */
fun SsoAdminClient.listInstancesPaginated(initialRequest: ListInstancesRequest): Flow<ListInstancesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listInstancesPaginated.listInstances(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listInstancesPaginated]
 * to access the nested member [InstanceMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [InstanceMetadata]
 */
@JvmName("listInstancesResponseInstanceMetadata")
fun Flow<ListInstancesResponse>.instances(): Flow<InstanceMetadata> =
    transform() { response ->
        response.instances?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListManagedPoliciesInPermissionSetResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListManagedPoliciesInPermissionSetRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListManagedPoliciesInPermissionSetResponse]
 */
fun SsoAdminClient.listManagedPoliciesInPermissionSetPaginated(initialRequest: ListManagedPoliciesInPermissionSetRequest): Flow<ListManagedPoliciesInPermissionSetResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listManagedPoliciesInPermissionSetPaginated.listManagedPoliciesInPermissionSet(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listManagedPoliciesInPermissionSetPaginated]
 * to access the nested member [AttachedManagedPolicy]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AttachedManagedPolicy]
 */
@JvmName("listManagedPoliciesInPermissionSetResponseAttachedManagedPolicy")
fun Flow<ListManagedPoliciesInPermissionSetResponse>.attachedManagedPolicies(): Flow<AttachedManagedPolicy> =
    transform() { response ->
        response.attachedManagedPolicies?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPermissionSetProvisioningStatusResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListPermissionSetProvisioningStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionSetProvisioningStatusResponse]
 */
fun SsoAdminClient.listPermissionSetProvisioningStatusPaginated(initialRequest: ListPermissionSetProvisioningStatusRequest): Flow<ListPermissionSetProvisioningStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPermissionSetProvisioningStatusPaginated.listPermissionSetProvisioningStatus(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listPermissionSetProvisioningStatusPaginated]
 * to access the nested member [PermissionSetProvisioningStatusMetadata]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PermissionSetProvisioningStatusMetadata]
 */
@JvmName("listPermissionSetProvisioningStatusResponsePermissionSetProvisioningStatusMetadata")
fun Flow<ListPermissionSetProvisioningStatusResponse>.permissionSetsProvisioningStatus(): Flow<PermissionSetProvisioningStatusMetadata> =
    transform() { response ->
        response.permissionSetsProvisioningStatus?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPermissionSetsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListPermissionSetsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionSetsResponse]
 */
fun SsoAdminClient.listPermissionSetsPaginated(initialRequest: ListPermissionSetsRequest): Flow<ListPermissionSetsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPermissionSetsPaginated.listPermissionSets(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listPermissionSetsPaginated]
 * to access the nested member [PermissionSetArn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PermissionSetArn]
 */
@JvmName("listPermissionSetsResponsePermissionSetArn")
fun Flow<ListPermissionSetsResponse>.permissionSets(): Flow<String> =
    transform() { response ->
        response.permissionSets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPermissionSetsProvisionedToAccountResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListPermissionSetsProvisionedToAccountRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionSetsProvisionedToAccountResponse]
 */
fun SsoAdminClient.listPermissionSetsProvisionedToAccountPaginated(initialRequest: ListPermissionSetsProvisionedToAccountRequest): Flow<ListPermissionSetsProvisionedToAccountResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPermissionSetsProvisionedToAccountPaginated.listPermissionSetsProvisionedToAccount(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listPermissionSetsProvisionedToAccountPaginated]
 * to access the nested member [PermissionSetArn]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PermissionSetArn]
 */
@JvmName("listPermissionSetsProvisionedToAccountResponsePermissionSetArn")
fun Flow<ListPermissionSetsProvisionedToAccountResponse>.permissionSets(): Flow<String> =
    transform() { response ->
        response.permissionSets?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTagsForResourceResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListTagsForResourceRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTagsForResourceResponse]
 */
fun SsoAdminClient.listTagsForResourcePaginated(initialRequest: ListTagsForResourceRequest): Flow<ListTagsForResourceResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTagsForResourcePaginated.listTagsForResource(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * This paginator transforms the flow returned by [listTagsForResourcePaginated]
 * to access the nested member [Tag]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Tag]
 */
@JvmName("listTagsForResourceResponseTag")
fun Flow<ListTagsForResourceResponse>.tags(): Flow<Tag> =
    transform() { response ->
        response.tags?.forEach {
            emit(it)
        }
    }
