// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssooidc.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssooidc.model.CreateTokenResponse
import aws.sdk.kotlin.services.ssooidc.model.SsoOidcException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateTokenOperationDeserializer: HttpDeserialize<CreateTokenResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateTokenResponse {
        if (!response.status.isSuccess()) {
            throwCreateTokenError(context, response)
        }
        val builder = CreateTokenResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateTokenOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCreateTokenError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsoOidcException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "AuthorizationPendingException" -> AuthorizationPendingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidClientException" -> InvalidClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidGrantException" -> InvalidGrantExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidScopeException" -> InvalidScopeExceptionDeserializer().deserialize(context, wrappedResponse)
        "SlowDownException" -> SlowDownExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnsupportedGrantTypeException" -> UnsupportedGrantTypeExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsoOidcException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateTokenOperationBody(builder: CreateTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessToken"))
    val EXPIRESIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("expiresIn"))
    val IDTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("idToken"))
    val REFRESHTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("refreshToken"))
    val TOKENTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tokenType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSTOKEN_DESCRIPTOR)
        field(EXPIRESIN_DESCRIPTOR)
        field(IDTOKEN_DESCRIPTOR)
        field(REFRESHTOKEN_DESCRIPTOR)
        field(TOKENTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSTOKEN_DESCRIPTOR.index -> builder.accessToken = deserializeString()
                EXPIRESIN_DESCRIPTOR.index -> builder.expiresIn = deserializeInt()
                IDTOKEN_DESCRIPTOR.index -> builder.idToken = deserializeString()
                REFRESHTOKEN_DESCRIPTOR.index -> builder.refreshToken = deserializeString()
                TOKENTYPE_DESCRIPTOR.index -> builder.tokenType = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
