// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.sts.model



/**
 * Contains the response to a successful GetCallerIdentity request, including information about the entity making the request.
 */
class GetCallerIdentityResponse private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account ID number of the account that owns or contains the calling entity.
     */
    val account: kotlin.String? = builder.account
    /**
     * The Amazon Web Services ARN associated with the calling entity.
     */
    val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier of the calling entity. The exact value depends on the type of entity that is making the call. The values returned are those listed in the **aws:userid** column in the [Principal table](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable) found on the **Policy Variables** reference page in the *IAM User Guide*.
     */
    val userId: kotlin.String? = builder.userId

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.sts.model.GetCallerIdentityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetCallerIdentityResponse(")
        append("account=$account,")
        append("arn=$arn,")
        append("userId=$userId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = account?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetCallerIdentityResponse

        if (account != other.account) return false
        if (arn != other.arn) return false
        if (userId != other.userId) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.sts.model.GetCallerIdentityResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Web Services account ID number of the account that owns or contains the calling entity.
         */
        var account: kotlin.String? = null
        /**
         * The Amazon Web Services ARN associated with the calling entity.
         */
        var arn: kotlin.String? = null
        /**
         * The unique identifier of the calling entity. The exact value depends on the type of entity that is making the call. The values returned are those listed in the **aws:userid** column in the [Principal table](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_variables.html#principaltable) found on the **Policy Variables** reference page in the *IAM User Guide*.
         */
        var userId: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.sts.model.GetCallerIdentityResponse) : this() {
            this.account = x.account
            this.arn = x.arn
            this.userId = x.userId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.sts.model.GetCallerIdentityResponse = GetCallerIdentityResponse(this)
    }
}
