// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.model



/**
 * The refresh status of a Trusted Advisor check.
 */
class TrustedAdvisorCheckRefreshStatus private constructor(builder: Builder) {
    /**
     * The unique identifier for the Trusted Advisor check.
     */
    val checkId: kotlin.String? = builder.checkId
    /**
     * The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
     */
    val millisUntilNextRefreshable: kotlin.Long = builder.millisUntilNextRefreshable
    /**
     * The status of the Trusted Advisor check for which a refresh has been requested:
     * + `none` - The check is not refreshed or the non-success status exceeds the timeout
     * + `enqueued` - The check refresh requests has entered the refresh queue
     * + `processing` - The check refresh request is picked up by the rule processing engine
     * + `success` - The check is successfully refreshed
     * + `abandoned` - The check refresh has failed
     */
    val status: kotlin.String? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckRefreshStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TrustedAdvisorCheckRefreshStatus(")
        append("checkId=$checkId,")
        append("millisUntilNextRefreshable=$millisUntilNextRefreshable,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = checkId?.hashCode() ?: 0
        result = 31 * result + (millisUntilNextRefreshable.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TrustedAdvisorCheckRefreshStatus

        if (checkId != other.checkId) return false
        if (millisUntilNextRefreshable != other.millisUntilNextRefreshable) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckRefreshStatus = Builder(this).apply(block).build()

    class Builder {
        /**
         * The unique identifier for the Trusted Advisor check.
         */
        var checkId: kotlin.String? = null
        /**
         * The amount of time, in milliseconds, until the Trusted Advisor check is eligible for refresh.
         */
        var millisUntilNextRefreshable: kotlin.Long = 0L
        /**
         * The status of the Trusted Advisor check for which a refresh has been requested:
         * + `none` - The check is not refreshed or the non-success status exceeds the timeout
         * + `enqueued` - The check refresh requests has entered the refresh queue
         * + `processing` - The check refresh request is picked up by the rule processing engine
         * + `success` - The check is successfully refreshed
         * + `abandoned` - The check refresh has failed
         */
        var status: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckRefreshStatus) : this() {
            this.checkId = x.checkId
            this.millisUntilNextRefreshable = x.millisUntilNextRefreshable
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.support.model.TrustedAdvisorCheckRefreshStatus = TrustedAdvisorCheckRefreshStatus(this)
    }
}
