// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.support.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.support.model.DescribeSeverityLevelsResponse
import aws.sdk.kotlin.services.support.model.SeverityLevel
import aws.sdk.kotlin.services.support.model.SupportException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeSeverityLevelsOperationDeserializer: HttpDeserialize<DescribeSeverityLevelsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeSeverityLevelsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeSeverityLevelsError(context, response)
        }
        val builder = DescribeSeverityLevelsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeSeverityLevelsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeSeverityLevelsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SupportException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedResponse)
        else -> SupportException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeSeverityLevelsOperationBody(builder: DescribeSeverityLevelsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SEVERITYLEVELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("severityLevels"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SEVERITYLEVELS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SEVERITYLEVELS_DESCRIPTOR.index -> builder.severityLevels =
                    deserializer.deserializeList(SEVERITYLEVELS_DESCRIPTOR) {
                        val col0 = mutableListOf<SeverityLevel>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSeverityLevelDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
